/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.block.entity;

import com.neep.meatlib.MeatLib;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.memory.MemoryManager;
import com.neep.neepmeat.api.plc.robot.RobotAction;
import com.neep.neepmeat.api.storage.DynamicLazyBlockApiCache;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.block.ExecutorBlock;
import com.neep.neepmeat.plc.block.entity.PLCExecutor;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.processor.VariableStack;
import com.neep.neepmeat.plc.robot.PLCActuator;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayDeque;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ExecutorBlockEntity
extends SyncableBlockEntity
implements PLC,
PLCExecutor {
    private final LazyBlockApiCache<Void, Void> cache = this.addListener(DynamicLazyBlockApiCache.voidCtx(MeatLib.VOID_LOOKUP, () -> ((ExecutorBlockEntity)this).method_10997(), () -> this.method_11016().method_10093((class_2350)this.method_11010().method_11654((class_2769)ExecutorBlock.field_11177))));
    @Nullable
    private Pair<RobotAction, PLC.PLCConsumer> currentAction;
    private final ArrayDeque<Instruction> instructions = new ArrayDeque();
    private PlcInstruction currentInstruction;
    private int flag;
    private final VariableStack variableStack = new VariableStack(8);
    @Nullable
    private PLC.Error error;

    public ExecutorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void serverTick() {
        if (this.error != null) {
            this.stop();
            this.say(this.error.what());
            this.error = null;
        }
        if (this.currentInstruction == null && !this.instructions.isEmpty()) {
            this.execute(this.instructions.peek());
        }
        if (this.currentAction != null) {
            if (((RobotAction)this.currentAction.first()).finished(this)) {
                ((RobotAction)this.currentAction.first()).end(this);
                try {
                    ((PLC.PLCConsumer)this.currentAction.second()).accept(this);
                }
                catch (NeepASM.RuntimeException e) {
                    this.raiseError(e);
                }
                this.currentAction = null;
                this.method_5431();
            } else {
                try {
                    ((RobotAction)this.currentAction.first()).tick(this);
                }
                catch (NeepASM.RuntimeException e) {
                    this.raiseError(e);
                }
            }
        }
        this.updateState();
    }

    private void updateState() {
        class_2680 state = this.method_11010();
        boolean prev = (Boolean)state.method_11654((class_2769)ExecutorBlock.ON);
        if ((!this.instructions.isEmpty() || this.currentInstruction != null) != prev) {
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)ExecutorBlock.ON, (Comparable)Boolean.valueOf(!this.instructions.isEmpty())));
        }
    }

    public void execute(Instruction instruction) {
        if (instruction instanceof PlcInstruction) {
            PlcInstruction plcInstruction = (PlcInstruction)instruction;
            if (this.currentAction != null) {
                this.currentAction = null;
            }
            this.currentInstruction = plcInstruction;
            try {
                if (plcInstruction.canStart(this)) {
                    plcInstruction.start(this);
                    if (this.currentAction != null) {
                        ((RobotAction)this.currentAction.first()).start(this);
                    }
                }
            }
            catch (NeepASM.RuntimeException e) {
                this.raiseError(e);
            }
            this.method_5431();
        } else {
            this.raiseError(new PLC.Error("Executor does not support " + instruction.getOpcode().getShortName()));
        }
    }

    private void say(class_2561 what) {
        PlayerLookup.around((class_3218)((class_3218)this.method_10997()), (class_2382)this.method_11016(), (double)20.0).forEach(p -> p.method_43496((class_2561)class_2561.method_30163((String)("[Executor at " + this.method_11016().method_10263() + " " + this.method_11016().method_10264() + " " + this.method_11016().method_10260() + "] ")).method_27661().method_10852(what)));
    }

    @Override
    public PLCActuator getActuator() {
        class_2586 class_25862 = this.cache.getBlockEntity();
        if (class_25862 instanceof PLCActuator) {
            PLCActuator actuator = (PLCActuator)class_25862;
            return actuator;
        }
        return PLCActuator.EMPTY;
    }

    @Override
    public void selectActuator(@Nullable class_2338 pos) {
    }

    @Override
    public void addRobotAction(RobotAction action, PLC.PLCConsumer callback) {
        this.currentAction = Pair.of((Object)action, (Object)callback);
    }

    @Override
    public int counter() {
        return 0;
    }

    @Override
    public void advanceCounter() {
        this.currentInstruction = null;
        this.instructions.poll();
        this.method_5431();
    }

    public void stop() {
        if (this.currentInstruction != null) {
            this.currentInstruction.cancel(this);
        }
        this.currentInstruction = null;
        this.instructions.clear();
        this.currentAction = null;
        this.method_5431();
    }

    @Override
    public VariableStack dataStack() {
        return this.variableStack;
    }

    @Override
    public DataStack returnStack() {
        return this.variableStack;
    }

    @Override
    public void say(String message) {
        PlayerLookup.around((class_3218)((class_3218)this.method_10997()), (class_2382)this.field_11867, (double)20.0).forEach(p -> p.method_43496(class_2561.method_30163((String)("[Executor at " + this.field_11867.method_10263() + " " + this.field_11867.method_10264() + " " + this.field_11867.method_10260() + "] " + message))));
    }

    @Override
    public MemoryManager getMemory() {
        return MemoryManager.EMPTY;
    }

    @Override
    public void setCounter(int counter) {
        if (counter == -1) {
            this.stop();
        }
    }

    @Override
    public void raiseError(PLC.Error error) {
        this.error = error;
        if (this.currentInstruction != null) {
            this.currentInstruction.cancel(this);
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("flag", this.flag);
        class_2499 list = new class_2499();
        for (Instruction instruction : this.instructions) {
            class_2487 instructionNbt = new class_2487();
            instruction.writeNbt(instructionNbt);
            instructionNbt.method_10582("id", instruction.getOpcode().getParseName());
            list.add((Object)instructionNbt);
        }
        nbt.method_10566("instructions", (class_2520)list);
    }

    public void raiseError(NeepASM.RuntimeException e) {
        this.raiseError(new PLC.Error(e));
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.flag = nbt.method_10550("flag");
        this.instructions.clear();
        class_2499 list = nbt.method_10554("instructions", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 instructionNbt = list.method_10602(i);
            String id = instructionNbt.method_10558("id");
            InstructionProvider provider = Instructions.REGISTRY.get(id);
            if (provider == null) continue;
            this.instructions.add(provider.createFromNbt(() -> ((ExecutorBlockEntity)this).method_10997(), instructionNbt));
        }
    }

    @Override
    public void receiveInstruction(Instruction instruction) {
        this.instructions.add(instruction);
    }
}

