/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CountInstruction
implements PlcInstruction {
    private static final Map<class_2960, BlockApiLookup<? extends Storage<? extends TransferVariant<?>>, class_2350>> LOOKUP_MAP = Map.of(ItemStorage.SIDED.getId(), ItemStorage.SIDED, FluidStorage.SIDED.getId(), FluidStorage.SIDED);
    private final BlockApiLookup<? extends Storage<? extends TransferVariant<?>>, class_2350> lookup;
    private final LazyBlockApiCache<? extends Storage<? extends TransferVariant<?>>, class_2350> targetCache;
    private final Argument target;
    private final Pattern pattern;

    public CountInstruction(Supplier<class_1937> world, BlockApiLookup<? extends Storage<? extends TransferVariant<?>>, class_2350> lookup, Argument target, String pattern) {
        this.target = target;
        this.pattern = Pattern.compile(pattern);
        this.lookup = lookup;
        this.targetCache = LazyBlockApiCache.of(lookup, world, target);
    }

    public CountInstruction(Supplier<class_1937> worldSupplier, class_2487 nbt) {
        this(worldSupplier, LOOKUP_MAP.getOrDefault(class_2960.method_12829((String)nbt.method_10558("lookup")), ItemStorage.SIDED), Argument.fromNbt(nbt.method_10562("target")), nbt.method_10558("pattern"));
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10582("lookup", this.lookup.getId().toString());
        nbt.method_10566("target", (class_2520)this.target.toNbt());
        nbt.method_10582("pattern", this.pattern.pattern());
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        Storage<? extends TransferVariant<?>> storage = this.targetCache.find();
        long found = 0L;
        if (storage != null) {
            for (StorageView view : storage) {
                if (!this.matches((TransferVariant)view.getResource())) continue;
                found += view.getAmount();
            }
        }
        plc.dataStack().push((int)found);
        plc.advanceCounter();
    }

    private <T extends TransferVariant<?>> boolean matches(T resource) {
        return this.pattern.asMatchPredicate().test(this.resourceToEntry(resource));
    }

    private <T extends TransferVariant<?>> String resourceToEntry(T resource) {
        Object object = resource.getObject();
        if (object instanceof class_1792) {
            class_1792 item = (class_1792)object;
            return item.method_40131().method_40237().method_29177().toString();
        }
        object = resource.getObject();
        if (object instanceof class_3611) {
            class_3611 fluid = (class_3611)object;
            return fluid.method_40178().method_40237().method_29177().toString();
        }
        return "";
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.COUNT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser) throws NeepASM.ParseException {
        String regex;
        String checkRegistry;
        class_7922 registry;
        view.fastForward();
        Argument argument = parser.parseWorldTarget(view);
        if (argument == null) {
            throw new NeepASM.ParseException("expected storage world target");
        }
        view.fastForward();
        if (view.peek() != '\"' && !view.lineEnded()) {
            String identifier = view.nextIdentifier();
            if (identifier.isEmpty()) {
                throw new NeepASM.ParseException("Expected 'item' or 'fluid'");
            }
            switch (identifier.toLowerCase()) {
                case "item": {
                    class_7922 class_79222 = class_7923.field_41178;
                    break;
                }
                case "fluid": {
                    class_7922 class_79222 = class_7923.field_41173;
                    break;
                }
                default: {
                    class_7922 class_79222 = registry = null;
                }
            }
            if (registry == null) {
                throw new NeepASM.ParseException("Expected 'item' or 'fluid'");
            }
        } else {
            registry = null;
        }
        view.fastForward();
        if (view.peek() == '\"') {
            String notGlob = view.nextString();
            if (notGlob == null) throw new NeepASM.ParseException("unterminated string");
            checkRegistry = NeepAsmParser.isSimplePattern(notGlob) ? notGlob : null;
            regex = NeepAsmParser.convertToRegex(notGlob);
        } else {
            regex = ".*";
            checkRegistry = null;
        }
        parser.assureLineEnd(view);
        return (world, parsedSource1, program) -> {
            BlockApiLookup<? extends Storage<? extends TransferVariant<?>>, class_2350> lookup = CountInstruction.findLookup(registry, (class_1937)world, argument, checkRegistry);
            program.addBack(new CountInstruction(() -> world, lookup, argument, regex));
        };
    }

    private static BlockApiLookup<? extends Storage<? extends TransferVariant<?>>, class_2350> findLookup(@Nullable class_2378<?> registry, class_1937 world, Argument argument, @Nullable String checkRegistry) throws NeepASM.CompilationException {
        if (registry == class_7923.field_41178) {
            CountInstruction.checkRegistry(registry, checkRegistry);
            CountInstruction.checkStorage(ItemStorage.SIDED, "item", world, argument);
            return ItemStorage.SIDED;
        }
        if (registry == class_7923.field_41173) {
            CountInstruction.checkRegistry(registry, checkRegistry);
            CountInstruction.checkStorage(FluidStorage.SIDED, "fluid", world, argument);
            return FluidStorage.SIDED;
        }
        if (registry == null) {
            Storage itemStorage = (Storage)CountInstruction.findStorage(ItemStorage.SIDED, world, argument);
            if (itemStorage != null) {
                CountInstruction.checkRegistry(class_7923.field_41178, checkRegistry);
                return ItemStorage.SIDED;
            }
            Storage fluidStorage = (Storage)CountInstruction.findStorage(FluidStorage.SIDED, world, argument);
            if (fluidStorage != null) {
                CountInstruction.checkRegistry(class_7923.field_41173, checkRegistry);
                return FluidStorage.SIDED;
            }
        }
        throw new NeepASM.CompilationException(String.format("no item or fluid storage at %s", argument));
    }

    @Nullable
    private static <T> T findStorage(BlockApiLookup<T, class_2350> lookup, class_1937 world, Argument argument) {
        return (T)lookup.find(world, argument.pos(), (Object)argument.face());
    }

    private static <T> void checkStorage(BlockApiLookup<T, class_2350> lookup, String type, class_1937 world, Argument argument) throws NeepASM.CompilationException {
        if (CountInstruction.findStorage(lookup, world, argument) == null) {
            throw new NeepASM.CompilationException(String.format("no %s storage at %s", type, argument));
        }
    }

    private static <T> void checkRegistry(class_2378<T> registry, @Nullable String string) throws NeepASM.CompilationException {
        if (string == null) {
            return;
        }
        Object object = registry.method_17966(class_2960.method_12829((String)string)).orElse(null);
        if (object == null) {
            throw new NeepASM.CompilationException(registry.method_30517().method_29177().method_12832() + " '" + string + "' not known");
        }
    }
}

