/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepbus.util.message.DataVariant;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.block.entity.PLCBlockEntity;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.memory.MemoryEntry;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeepBusReadInstruction
implements PlcInstruction {
    private final String address;

    public NeepBusReadInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this(nbt.method_10558("address"));
    }

    public NeepBusReadInstruction(String address) {
        this.address = address;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10582("address", this.address);
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        if (plc instanceof PLCBlockEntity) {
            PLCBlockEntity be = (PLCBlockEntity)plc;
            DataVariant read = be.getSender().read(this.address);
            if (read.isNumeric()) {
                be.dataStack().push(read.intValue());
            } else {
                plc.dataStack().push(plc.getMemory().allocate(MemoryEntry.of(read)), true);
            }
        }
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.NEEPBUS_READ;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser, @Nullable String s) throws NeepASM.ParseException {
        String address = view.nextString();
        if (address == null) {
            throw new NeepASM.ParseException("Expected address string");
        }
        parser.assureLineEnd(view);
        return (world, parsedSource1, program) -> program.addBack(new NeepBusReadInstruction(address));
    }
}

