/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.robot.PLCActuator;
import com.neep.neepmeat.transport.api.item_network.RoutingNetwork;
import com.neep.neepmeat.transport.block.item_transport.PipeDriverBlock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class RequestItemInstruction
implements PlcInstruction {
    private final Argument to;
    private final Pattern pattern;

    public RequestItemInstruction(Supplier<class_1937> worldSupplier, Argument to, String pattern) {
        this.pattern = Pattern.compile(pattern);
        this.to = to;
    }

    public RequestItemInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this(world, Argument.fromNbt(nbt.method_10562("to")), nbt.method_10558("pattern"));
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10582("pattern", this.pattern.pattern());
        nbt.method_10566("to", (class_2520)this.to.toNbt());
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        DataStack stack = plc.dataStack();
        int amount = 0;
        amount = stack.isEmpty() ? 1 : plc.dataStack().popInt();
        PLCActuator pLCActuator = plc.getActuator();
        if (pLCActuator instanceof PipeDriverBlock.PipeDriverBlockEntity) {
            PipeDriverBlock.PipeDriverBlockEntity be = (PipeDriverBlock.PipeDriverBlockEntity)pLCActuator;
            try (Transaction transaction = Transaction.openOuter();){
                Predicate<ItemVariant> predicate = v -> Instructions.match(this.pattern, v.getItem());
                boolean satisfied = be.getNetwork(null).request(predicate, amount, this.to.pos(), this.to.face(), RoutingNetwork.RequestType.EXACT_AMOUNT, (TransactionContext)transaction);
                if (satisfied) {
                    transaction.commit();
                }
                plc.dataStack().push(satisfied ? -1 : 0);
            }
        } else {
            plc.raiseError(new PLC.Error("Actuator is not a pipe driver"));
        }
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.REQUEST;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser) throws NeepASM.ParseException {
        view.fastForward();
        Argument to = parser.parseWorldTarget(view);
        if (to == null) {
            throw new NeepASM.ParseException("expected output pipe world target");
        }
        String regex = Instructions.parseRegistryGlob(view, class_7923.field_41178, "item");
        view.fastForward();
        parser.assureLineEnd(view);
        return (world, parsedSource1, program) -> program.addBack(new RequestItemInstruction(() -> world, to, regex));
    }
}

