/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction.memory;

import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.memory.MemoryManager;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.memory.MemoryEntry;
import com.neep.neepmeat.plc.processor.MemoryType;
import org.jetbrains.annotations.NotNull;

public class FetchInstruction
implements PlcInstruction {
    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        int address;
        DataStack stack = plc.dataStack();
        MemoryManager memory = plc.getMemory();
        MemoryEntry entry = memory.fetch(address = stack.popInt());
        if (entry != null && entry.type() == MemoryType.INTEGER) {
            stack.push(((MemoryEntry.IntegerEntry)entry).value());
        } else {
            plc.raiseError(new PLC.Error("Item at address cannot be put on the stack"));
        }
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.FETCH;
    }
}

