/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.program;

import com.google.common.collect.Lists;
import com.neep.neepmeat.api.plc.program.MutableProgram;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class PLCProgramImpl
implements MutableProgram {
    private final Supplier<class_1937> worldSupplier;
    protected ArrayList<Instruction> instructions = Lists.newArrayList();
    private final IntList debugLines = new IntArrayList();
    private int debugLine = -1;

    public PLCProgramImpl(Supplier<class_1937> worldSupplier) {
        this.worldSupplier = worldSupplier;
    }

    @Override
    public Instruction get(int index) {
        if (index < this.instructions.size()) {
            return this.instructions.get(index);
        }
        return Instruction.end();
    }

    @Override
    public int size() {
        return this.instructions.size();
    }

    @Override
    public int getDebugLine(int counter) {
        if (counter == -1 || counter >= this.debugLines.size()) {
            return -1;
        }
        return this.debugLines.getInt(counter);
    }

    @Override
    public void addBack(Instruction instruction) {
        this.debugLines.add(this.debugLine);
        this.instructions.add(instruction);
    }

    @Override
    public void setDebugLine(int line) {
        this.debugLine = line;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (int i = 0; i < this.instructions.size(); ++i) {
            Instruction instruction = this.instructions.get(i);
            int line = this.debugLines.getInt(i);
            class_2487 instructionNbt = new class_2487();
            instruction.writeNbt(instructionNbt);
            instructionNbt.method_10569("debug_line", line);
            instructionNbt.method_10582("id", instruction.getOpcode().getParseName());
            list.add((Object)instructionNbt);
        }
        nbt.method_10566("instructions", (class_2520)list);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.instructions.clear();
        class_2499 list = nbt.method_10554("instructions", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 instructionNbt = list.method_10602(i);
            int line = instructionNbt.method_10550("debug_line");
            InstructionProvider provider = Instructions.REGISTRY.get(instructionNbt.method_10558("id"));
            if (provider == null) continue;
            this.instructions.add(provider.createFromNbt(this.worldSupplier, instructionNbt));
            this.debugLines.add(line);
        }
    }
}

