/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.recipe;

import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatRecipeType;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.recipe.RecipeRegistry;
import com.neep.neepmeat.api.plc.recipe.ManufactureStep;
import com.neep.neepmeat.api.plc.recipe.Workpiece;
import com.neep.neepmeat.init.NMItems;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.plc.recipe.CombineStep;
import com.neep.neepmeat.plc.recipe.EntityImplantRecipe;
import com.neep.neepmeat.plc.recipe.EntityMutateRecipe;
import com.neep.neepmeat.plc.recipe.EntityToItemRecipe;
import com.neep.neepmeat.plc.recipe.ImplantStep;
import com.neep.neepmeat.plc.recipe.InjectStep;
import com.neep.neepmeat.plc.recipe.ItemManufactureRecipe;
import com.neep.neepmeat.plc.recipe.ManufactureRecipe;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import org.jetbrains.annotations.Nullable;

public class PLCRecipes {
    public static final MeatRecipeSerialiser<ItemManufactureRecipe> MANUFACTURE_SERIALISER = RecipeRegistry.registerMeatlibSerializer("neepmeat", "manufacture", new ItemManufactureRecipe.Serialiser());
    public static final MeatRecipeType<ItemManufactureRecipe> MANUFACTURE = RecipeRegistry.registerMeatlibType("neepmeat", "manufacture");
    public static final MeatRecipeSerialiser<EntityImplantRecipe> ENTITY_MANUFACTURE_SERIALISER = RecipeRegistry.registerMeatlibSerializer("neepmeat", "entity_manufacture", new EntityImplantRecipe.Serialiser());
    public static final MeatRecipeType<EntityImplantRecipe> ENTITY_MANUFACTURE = RecipeRegistry.registerMeatlibType("neepmeat", "entity_manufacture");
    public static final MeatRecipeSerialiser<EntityToItemRecipe> ENTITY_TO_ITEM_SERIALISER = RecipeRegistry.registerMeatlibSerializer("neepmeat", "entity_to_item", new EntityToItemRecipe.Serialiser());
    public static final MeatRecipeType<EntityToItemRecipe> ENTITY_TO_ITEM = RecipeRegistry.registerMeatlibType("neepmeat", "entity_to_item");
    public static final ManufactureStep.Provider<?> COMBINE = ManufactureStep.register(CombineStep.ID, ManufactureStep.Provider.of(CombineStep::get, CombineStep.CODEC));
    public static final ManufactureStep.Provider<?> INJECT = ManufactureStep.register(InjectStep.ID, ManufactureStep.Provider.of(InjectStep::new, InjectStep.CODEC));
    public static final ManufactureStep.Provider<?> IMPLANT = ManufactureStep.register(ImplantStep.ID, ManufactureStep.Provider.of(ImplantStep::new, ImplantStep.CODEC));

    public static <B, C, T extends ManufactureRecipe<C, B>> boolean isValidStep(MeatRecipeType<T> type, Workpiece workpiece, ManufactureStep<?> nextStep, B base) {
        if (base == NMItems.TRANSFORMING_TOOL_BASE) {
            return true;
        }
        List<ManufactureStep<?>> steps = workpiece.getSteps();
        for (ManufactureRecipe recipe : MeatlibRecipes.getInstance().getAllOfTypeSafe(type).values()) {
            if (!Objects.equals(recipe.getBase(), base)) continue;
            List<ManufactureStep<?>> recipeSteps = recipe.getSteps();
            int nextStepIdx = steps.size();
            if (recipeSteps.size() < steps.size() + 1 || !ManufactureStep.equals(recipeSteps.get(nextStepIdx), nextStep)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static EntityMutateRecipe matchEntityMutate(MutateInPlace<class_1297> mip) {
        EntityMutateRecipe recipe = MeatlibRecipes.getInstance().getFirstMatch(ENTITY_MANUFACTURE, mip).orElse(null);
        if (recipe != null) {
            return recipe;
        }
        recipe = MeatlibRecipes.getInstance().getFirstMatch(ENTITY_TO_ITEM, mip).orElse(null);
        return recipe;
    }

    public static void init() {
    }
}

