/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.robot;

import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.api.plc.interrupt.InterruptEmitter;
import com.neep.neepmeat.api.plc.interrupt.InterruptReceiver;
import com.neep.neepmeat.neepasm.program.Label;
import com.neep.neepmeat.plc.Instructions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public class InterruptManager
implements NbtSerialisable {
    private final Map<class_2338, Label> table = new HashMap<class_2338, Label>();
    private final Supplier<class_1937> worldSupplier;
    private final InterruptReceiver receiver;
    private final Runnable markDirty;
    private final Deque<Label> interruptQueue = new ArrayDeque<Label>();
    private boolean needsUpdate = true;
    private boolean enabled = true;
    private final int maxEvents = 32;

    public InterruptManager(Supplier<class_1937> worldSupplier, InterruptReceiver receiver, Runnable markDirty) {
        this.worldSupplier = worldSupplier;
        this.receiver = receiver;
        this.markDirty = markDirty;
    }

    public void put(class_2338 pos, Label label) {
        this.table.put(pos, label);
        class_2586 class_25862 = this.worldSupplier.get().method_8321(pos);
        if (class_25862 instanceof InterruptEmitter) {
            InterruptEmitter emitter = (InterruptEmitter)class_25862;
            emitter.addListener(this.receiver);
        }
        this.markDirty.run();
    }

    public void remove(class_2338 pos) {
        this.table.remove(pos);
    }

    public void clear() {
        this.table.clear();
        this.interruptQueue.clear();
    }

    public void update() {
        if (!this.needsUpdate) {
            return;
        }
        this.needsUpdate = false;
        for (class_2338 pos : this.table.keySet()) {
            class_2586 class_25862 = this.worldSupplier.get().method_8321(pos);
            if (!(class_25862 instanceof InterruptEmitter)) continue;
            InterruptEmitter emitter = (InterruptEmitter)class_25862;
            emitter.addListener(this.receiver);
        }
    }

    public boolean contains(class_2338 pos) {
        return this.table.containsKey(pos);
    }

    @Nullable
    public Label get(class_2338 pos) {
        return this.table.get(pos);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10556("enabled", this.enabled);
        class_2499 list = new class_2499();
        this.table.forEach((p, l) -> {
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)p));
            nbtCompound.method_10566("label", (class_2520)Instructions.labelToNbt(l));
            list.add((Object)nbtCompound);
        });
        nbt.method_10566("interrupt_table", (class_2520)list);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.table.clear();
        this.enabled = nbt.method_10577("enabled");
        class_2499 list = nbt.method_10554("interrupt_table", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 compound = list.method_10602(i);
            class_2338 pos = class_2512.method_10691((class_2487)compound.method_10562("pos"));
            Label label = Instructions.labelFromNbt(compound.method_10562("label"));
            this.table.put(pos, label);
        }
        this.needsUpdate = true;
    }

    public void interrupt(class_2338 pos, InterruptEmitter emitter) {
        if (!this.enabled || this.interruptQueue.size() > 32) {
            return;
        }
        Label label = this.table.get(pos);
        if (label == null) {
            return;
        }
        this.interruptQueue.add(label);
    }

    public Label peek() {
        return this.interruptQueue.peek();
    }

    public Label poll() {
        return this.interruptQueue.poll();
    }

    public boolean hasQueued() {
        return this.enabled && !this.interruptQueue.isEmpty();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

