/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.screen;

import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.network.ChannelManager;
import com.neep.neepmeat.api.plc.program.PLCProgram;
import com.neep.neepmeat.client.screen.plc.LanguageMode;
import com.neep.neepmeat.client.screen.plc.RecordMode;
import com.neep.neepmeat.init.NMScreenHandlers;
import com.neep.neepmeat.network.ScreenPropertyC2SPacket;
import com.neep.neepmeat.network.plc.PLCSyncAction;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.block.entity.PLCBlockEntity;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.screen.ThingConsumer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3913;
import net.minecraft.class_3919;

public class PLCScreenHandler
extends class_1703 {
    private final class_3913 delegate;
    private final PLCBlockEntity plc;
    private final String initialText;
    public final ChannelManager<ApplyAction> channel;
    public final ChannelManager<ChangeOperation> changeOperation;
    public final ChannelManager<ApplyArgument> applyArgument;
    public final ChannelManager<Consumer<RecordMode>> changeMode;
    public final ChannelManager<Consumer<LanguageMode>> changeLanguage;
    public final ChannelManager<Consumer<String>> updateText;
    public final ChannelManager<ApplyCompileMessage> compileMessageS2C;
    public final ChannelManager<Consumer<class_2487>> updateStackS2C;
    public final ChannelManager<Consumer<ByteBuf>> updateMemoryS2C;

    public PLCScreenHandler(int syncId, class_1661 playerInventory, class_2540 buf) {
        this(syncId, playerInventory.field_7546, (PLCBlockEntity)playerInventory.field_7546.method_37908().method_8321(buf.method_10811()), (class_3913)new class_3919(PLCBlockEntity.PLCPropertyDelegate.SIZE), buf.method_19772());
        this.delegate.method_17391(PLCBlockEntity.PLCPropertyDelegate.Names.EDIT_MODE.ordinal(), buf.readInt());
    }

    public PLCScreenHandler(int syncId, class_1657 player, PLCBlockEntity plc, class_3913 delegate, String source) {
        super(NMScreenHandlers.PLC, syncId);
        this.plc = plc;
        this.delegate = delegate;
        this.initialText = source;
        this.method_17360(delegate);
        this.channel = ChannelManager.create(new class_2960("neepmeat", "plc_sync_program"), ChannelFormat.builder(ApplyAction.class).param(PLCSyncAction.PARAM_CODEC).build(), player);
        this.changeOperation = ChannelManager.create(new class_2960("neepmeat", "change_operation"), ChannelFormat.builder(ChangeOperation.class).param(ParamCodec.STRING).build(), player);
        this.applyArgument = ChannelManager.create(new class_2960("neepmeat", "apply_argument"), ChannelFormat.builder(ApplyArgument.class).param(Argument.PARAM_CODEC).build(), player);
        this.changeMode = ChannelManager.create(new class_2960("neepmeat", "change_mode"), ChannelFormat.builder(ThingConsumer.as()).param(RecordMode.PARAM_CODEC).build(), player);
        this.changeLanguage = ChannelManager.create(new class_2960("neepmeat", "change_language"), ChannelFormat.builder(ThingConsumer.as()).param(LanguageMode.PARAM_CODEC).build(), player);
        this.updateText = ChannelManager.create(new class_2960("neepmeat", "update_text"), ChannelFormat.builder(ThingConsumer.as()).param(ParamCodec.STRING).build(), player);
        this.compileMessageS2C = ChannelManager.create(new class_2960("neepmeat", "compile_message"), ChannelFormat.builder(ApplyCompileMessage.class).param(ParamCodec.STRING).param(ParamCodec.BOOLEAN).param(ParamCodec.INT).build(), player);
        this.updateStackS2C = ChannelManager.create(new class_2960("neepmeat", "update_stack"), ChannelFormat.builder(ThingConsumer.as()).param(ParamCodec.NBT).build(), player);
        this.updateMemoryS2C = ChannelManager.create(new class_2960("neepmeat", "update_memory"), ChannelFormat.builder(ThingConsumer.as()).param(ParamCodec.BYTE_BUF).build(), player);
        this.channel.receiver(this::onApply);
        this.changeOperation.receiver(this::changeOperation);
        this.applyArgument.receiver(this::applyArgument);
        this.changeMode.receiver(plc::setMode);
        this.changeLanguage.receiver(plc::setLanguage);
        this.updateText.receiver(s -> plc.getProgramEditor().setProgramSource((String)s));
    }

    public void method_37420() {
        super.method_37420();
    }

    public void method_7623() {
        super.method_7623();
        this.updateStackS2C.emitter().accept(this.plc.getVariableStack().writeNbt(new class_2487()));
        ByteBuf bb = Unpooled.buffer();
        this.plc.getMemory().write(bb);
        this.updateMemoryS2C.emitter().accept(bb);
    }

    public void method_34252() {
        super.method_34252();
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public PLCBlockEntity getPlc() {
        return this.plc;
    }

    public RecordMode getMode() {
        return RecordMode.values()[this.delegate.method_17390(PLCBlockEntity.PLCPropertyDelegate.Names.EDIT_MODE.ordinal())];
    }

    public boolean isRunning() {
        return this.delegate.method_17390(PLCBlockEntity.PLCPropertyDelegate.Names.RUNNING.ordinal()) > 0;
    }

    public int getCounter() {
        return this.delegate.method_17390(PLCBlockEntity.PLCPropertyDelegate.Names.PROGRAM_COUNTER.ordinal());
    }

    public int getMaxArguments() {
        return this.delegate.method_17390(PLCBlockEntity.PLCPropertyDelegate.Names.MAX_ARGUMENTS.ordinal());
    }

    public LanguageMode getLanguage() {
        return LanguageMode.values()[this.delegate.method_17390(PLCBlockEntity.PLCPropertyDelegate.Names.LANGUAGE.ordinal())];
    }

    public int getArguments() {
        return this.delegate.method_17390(PLCBlockEntity.PLCPropertyDelegate.Names.ARGUMENT.ordinal());
    }

    public void setSelectedInstruction(int index) {
        ScreenPropertyC2SPacket.Client.send(PLCBlockEntity.PLCPropertyDelegate.Names.SELECTED_INSTRUCTION.ordinal(), index);
    }

    public int getSelectedInstruction() {
        return this.delegate.method_17390(PLCBlockEntity.PLCPropertyDelegate.Names.SELECTED_INSTRUCTION.ordinal());
    }

    public String getInitialText() {
        return this.initialText;
    }

    public int hasProgram() {
        return this.delegate.method_17390(PLCBlockEntity.PLCPropertyDelegate.Names.HAS_PROGRAM.ordinal());
    }

    public int debugLine() {
        return this.delegate.method_17390(PLCBlockEntity.PLCPropertyDelegate.Names.DEBUG_LINE.ordinal());
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.channel.close();
        this.changeOperation.close();
        this.applyArgument.close();
        this.changeMode.close();
        this.changeLanguage.close();
        this.updateText.close();
        this.compileMessageS2C.close();
        this.updateStackS2C.close();
        this.updateMemoryS2C.close();
    }

    private void onApply(PLCSyncAction action) {
        switch (action) {
            case RUN: {
                this.plc.runProgram(this.plc.getProgramEditor().getProgram());
                break;
            }
            case STOP: {
                this.plc.hardStop();
                break;
            }
            case PAUSE: {
                this.plc.pause();
                break;
            }
            case COMPILE: {
                this.plc.getProgramEditor().compile(p -> {});
                break;
            }
            case STEP: {
                this.plc.step();
                break;
            }
            case COMPILE_RUN: {
                this.plc.getProgramEditor().compile(program -> {
                    this.plc.hardStop();
                    this.plc.runProgram((PLCProgram)program);
                });
            }
        }
    }

    private void changeOperation(String id) {
        InstructionProvider provider = Instructions.REGISTRY.get(id);
        if (provider != null) {
            this.plc.getState().setInstructionBuilder(provider);
        }
    }

    private void applyArgument(Argument argument) {
        this.plc.getState().argument(argument);
    }

    @FunctionalInterface
    public static interface ApplyAction {
        public void apply(PLCSyncAction var1);
    }

    @FunctionalInterface
    public static interface ChangeOperation {
        public void apply(String var1);
    }

    @FunctionalInterface
    public static interface ApplyArgument {
        public void apply(Argument var1);
    }

    @FunctionalInterface
    public static interface ApplyCompileMessage {
        public void apply(String var1, boolean var2, int var3);
    }
}

