/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.screen_handler;

import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.network.ChannelManager;
import com.neep.meatlib.screen.ScreenReadyListener;
import com.neep.neepmeat.init.NMScreenHandlers;
import com.neep.neepmeat.machine.content_detector.InventoryDetector;
import com.neep.neepmeat.screen_handler.BasicScreenHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class ContentDetectorScreenHandler
extends BasicScreenHandler
implements ScreenReadyListener {
    private boolean ready;
    public final ChannelManager<UpdateButtons> updateButtons;
    public final ChannelManager<ButtonPress> buttonPress;
    private final InventoryDetector parent;

    public ContentDetectorScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, (class_1263)new class_1277(9), InventoryDetector.EMPTY);
    }

    public ContentDetectorScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory, InventoryDetector detector) {
        super(NMScreenHandlers.CONTENT_DETECTOR_SCREEN_HANDLER, playerInventory, inventory, syncId, null);
        this.updateButtons = ChannelManager.create(new class_2960("neepmeat", "update_buttons"), ChannelFormat.builder(UpdateButtons.class).param(InventoryDetector.CountMode.CODEC).param(InventoryDetector.BehaviourMode.CODEC).build(), playerInventory.field_7546);
        this.buttonPress = ChannelManager.create(new class_2960("neepmeat", "button_press"), ChannelFormat.builder(ButtonPress.class).param(ParamCodec.INT).build(), playerInventory.field_7546);
        this.parent = detector;
        ContentDetectorScreenHandler.method_17359((class_1263)inventory, (int)9);
        this.createSlotBlock(0, 0, 3, 3, inventory, 0, class_1735::new);
        this.createPlayerSlots(0, 0, playerInventory);
        if (!this.isClient()) {
            this.buttonPress.receiver(this::onButtonPress);
        }
    }

    private void onButtonPress(int button) {
        if (button == 0) {
            this.parent.cycleCountMode();
        } else if (button == 1) {
            this.parent.cycleBehaviourMode();
        }
    }

    @Override
    public void method_7623() {
        super.method_7623();
        if (this.ready) {
            this.updateButtons.emitter().update(this.parent.getCountMode(), this.parent.getBehaviourMode());
        }
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.inventory.method_5439() ? !this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size(), true) : !this.method_7616(originalStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.updateButtons.close();
        this.buttonPress.close();
    }

    @Override
    public void onScreenReady() {
        this.ready = true;
    }

    public static interface UpdateButtons {
        public void update(InventoryDetector.CountMode var1, InventoryDetector.BehaviourMode var2);
    }

    public static interface ButtonPress {
        public void press(int var1);
    }
}

