/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.thord.parser;

import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.InstructionAcceptor;
import com.neep.neepmeat.neepasm.compiler.LabelLookup;
import com.neep.neepmeat.neepasm.compiler.ParsedFunction;
import com.neep.neepmeat.neepasm.compiler.ParsedInstructionList;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedMacro;
import com.neep.neepmeat.neepasm.program.Label;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ThordParsedSource
implements LabelLookup,
InstructionAcceptor,
ParsedInstructionList {
    private final List<ObjectIntPair<ParsedInstruction>> instructions = new ObjectArrayList();
    private final List<Label> labels = new ObjectArrayList();
    private final List<ParsedFunction> functions = new ObjectArrayList();

    @Override
    @Nullable
    public Label findLabel(String label) {
        return this.labels.stream().filter(l -> l.name().equals(label)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public Label findLabel(String label, int origin, Label.Seek seek) {
        return switch (seek) {
            default -> throw new IncompatibleClassChangeError();
            case Label.Seek.FORWARDS -> LabelLookup.findForwards(this.labels, label, origin);
            case Label.Seek.BACKWARDS -> LabelLookup.findBackwards(this.labels, label, origin);
            case Label.Seek.ABSOLUTE -> this.findLabel(label);
        };
    }

    @Override
    public void instruction(ParsedInstruction preInstruction, int line) {
        this.instructions.add((ObjectIntPair<ParsedInstruction>)ObjectIntPair.of((Object)preInstruction, (int)line));
    }

    @Override
    public void instruction(int index, ParsedInstruction preInstruction, int line) throws NeepASM.CompilationException {
        if (index < 0 || index > this.instructions.size()) {
            throw new NeepASM.CompilationException("instruction at offset " + index + " cannot be replaced");
        }
        if (index == this.instructions.size()) {
            this.instruction(preInstruction, line);
        } else {
            int prevLine = this.instructions.get(index).valueInt();
            this.instructions.set(index, (ObjectIntPair<ParsedInstruction>)ObjectIntPair.of((Object)preInstruction, (int)prevLine));
        }
    }

    @Override
    public Iterable<ObjectIntPair<ParsedInstruction>> instructions() {
        return this.instructions;
    }

    @Override
    public void label(Label label) {
        this.labels.add(label);
    }

    @Override
    public void function(ParsedFunction function) {
        this.functions.add(function);
    }

    public List<ParsedFunction> functions() {
        return this.functions;
    }

    @Override
    public int size() {
        return this.instructions.size();
    }

    @Override
    @Nullable
    public ParsedMacro findMacro(String name) {
        return null;
    }
}

