/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.thord.word;

import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.InstructionAcceptor;
import com.neep.neepmeat.thord.compiler.CompilerVM;
import com.neep.neepmeat.thord.parser.ParsedImmediateWord;
import com.neep.neepmeat.thord.word.Word;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.Nullable;

public record ImmediateWord(String name, ParsedImmediateWord words, IntConsumer lineConsumer) implements Word
{
    @Override
    public void expand(InstructionAcceptor acceptor, CompilerVM stack, int line) throws NeepASM.NeepAsmException {
        stack.resetCounter();
        while (stack.counter() >= 0 && stack.counter() < this.words.size()) {
            int prevCounter = stack.counter();
            ObjectIntPair<Word> pair = this.getWord(prevCounter);
            if (pair == null) {
                return;
            }
            this.lineConsumer.accept(pair.valueInt());
            ((Word)pair.key()).expand(acceptor, stack, line);
            if (stack.counter() > prevCounter) continue;
            stack.setCounter(prevCounter + 1);
        }
    }

    @Nullable
    private ObjectIntPair<Word> getWord(int index) {
        if (index >= 0 && index < this.words.size()) {
            return this.words.getWords().get(index);
        }
        return null;
    }
}

