/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.api;

import com.neep.meatlib.blockentity.BlockEntityInvalidateListener;
import com.neep.neepmeat.api.FluidPump;
import com.neep.neepmeat.api.storage.DynamicLazyBlockApiCache;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.transport.api.FluidTransportConstants;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public interface AutoEjector<T>
extends BlockEntityInvalidateListener {
    public static SingleFaceFluid<FluidVariant> simpleFluid(Supplier<class_2350> side, class_2586 blockEntity, Storage<FluidVariant> backing, FluidPump pump) {
        return new SingleFaceFluid<FluidVariant>(side, () -> ((class_2586)blockEntity).method_10997(), blockEntity.method_11016(), backing, FluidStorage.SIDED, pump);
    }

    public static SingleFaceFluid<FluidVariant> simpleFluid(Supplier<class_2350> side, Supplier<class_1937> worldSupplier, class_2338 pos, Storage<FluidVariant> backing, FluidPump pump) {
        return new SingleFaceFluid<FluidVariant>(side, worldSupplier, pos, backing, FluidStorage.SIDED, pump);
    }

    public void tick(@Nullable Transaction var1);

    @Override
    public void invalidate();

    public static class SingleFaceFluid<T>
    implements AutoEjector<T> {
        private final Supplier<class_1937> worldSupplier;
        private final Storage<T> backing;
        private final FluidPump pump;
        private final LazyBlockApiCache<Storage<T>, class_2350> apiCache;

        private SingleFaceFluid(Supplier<class_2350> side, Supplier<class_1937> worldSupplier, class_2338 pos, Storage<T> backing, BlockApiLookup<Storage<T>, class_2350> lookup, FluidPump pump) {
            this.worldSupplier = worldSupplier;
            this.backing = backing;
            this.pump = pump;
            this.apiCache = DynamicLazyBlockApiCache.of(worldSupplier, lookup, () -> pos.method_10093((class_2350)side.get()), () -> ((class_2350)side.get()).method_10153());
        }

        @Override
        public void tick(@Nullable Transaction transaction) {
            class_3218 serverWorld;
            class_1937 class_19372 = this.worldSupplier.get();
            if (class_19372 instanceof class_3218 && (serverWorld = (class_3218)class_19372).method_8510() % 2L == 0L) {
                int rate;
                Storage<T> storage;
                boolean fluidPresent = true;
                Storage<T> storage2 = this.backing;
                if (storage2 instanceof SingleVariantStorage) {
                    SingleVariantStorage single = (SingleVariantStorage)storage2;
                    boolean bl = fluidPresent = single.getAmount() > 0L;
                }
                if (fluidPresent && (storage = this.apiCache.find()) != null && (rate = (int)(2.0f * this.pump.getFlow() * (float)FluidTransportConstants.INSTANCE.maxTransfer())) < 0) {
                    StorageUtil.move(this.backing, storage, v -> true, (long)(-rate), (TransactionContext)transaction);
                }
            }
        }

        @Override
        public void invalidate() {
            this.apiCache.invalidate();
        }
    }
}

