/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.api.pipe;

import com.neep.meatlib.util.graph.ConnectablePipe;
import com.neep.neepmeat.transport.api.pipe.AbstractAxialFluidPipe;
import com.neep.neepmeat.transport.api.pipe.PipeConnections;
import com.neep.neepmeat.transport.api.pipe.PrecisePipeBlock;
import com.neep.neepmeat.transport.block.fluid_transport.FluidPipeBlock;
import com.neep.neepmeat.transport.block.fluid_transport.machine.FluidPipeBlockEntity;
import com.neep.neepmeat.transport.fluid_network.ConnectionType;
import com.neep.neepmeat.transport.fluid_network.FluidNodeManager;
import com.neep.neepmeat.transport.fluid_network.FluidNodeManagerImpl;
import com.neep.neepmeat.transport.fluid_network.FluidPipeVertex;
import com.neep.neepmeat.transport.fluid_network.node.AcceptorModes;
import com.neep.neepmeat.transport.fluid_network.node.NodePos;
import java.util.EnumSet;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public interface FluidPipe
extends ConnectablePipe {
    public static boolean isConnectedIn(class_1922 world, class_2338 pos, class_2680 state, class_2350 direction) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof FluidPipeBlock) {
            FluidPipeBlock fluidPipeBlock = (FluidPipeBlock)class_22482;
            return ((ConnectionType)((Object)state.method_11654(fluidPipeBlock.getConnection(direction)))).isConnected();
        }
        class_22482 = state.method_26204();
        if (class_22482 instanceof FluidPipe) {
            FluidPipe acceptor = (FluidPipe)class_22482;
            return acceptor.connectInDirection(world, pos, state, direction);
        }
        return false;
    }

    @Override
    default public boolean isConnected(class_1922 world, class_2338 pos, class_2680 state, class_2350 direction) {
        return FluidPipe.isConnectedIn(world, pos, state, direction);
    }

    public static FluidPipe findFluidPipe(class_1937 world, class_2338 pos, class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof FluidPipe) {
            FluidPipe pipe = (FluidPipe)class_22482;
            return pipe;
        }
        return null;
    }

    public static void onStateReplaced(class_1937 world, class_2338 pos, class_2680 state, class_2680 newState, FluidPipe fluidPipe) {
        if (!world.method_8608() && !newState.method_27852(state.method_26204())) {
            FluidPipeBlockEntity.find(world, pos).ifPresent(be -> be.prepareForRemoval(state, newState));
        }
    }

    default public boolean createStorageNodes(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            boolean changed = false;
            for (class_2350 direction : class_2350.values()) {
                if (FluidPipe.isConnectedIn((class_1922)world, pos, state, direction)) {
                    if (!FluidNodeManager.getInstance(world).updatePosition(world, new NodePos(pos, direction))) continue;
                    changed = true;
                    continue;
                }
                changed |= FluidNodeManager.getInstance(world).removeNode(new NodePos(pos, direction));
            }
            return changed;
        }
        return false;
    }

    @Override
    default public PipeConnections getConnections(class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof PrecisePipeBlock) {
            PrecisePipeBlock pipeBlock = (PrecisePipeBlock)class_22482;
            PipeConnections set = new PipeConnections();
            for (class_2350 direction : class_2350.values()) {
                if (!((ConnectionType)((Object)state.method_11654(pipeBlock.getConnection(direction)))).isConnected()) continue;
                set.set(direction);
            }
            return set;
        }
        if (state.method_26204() instanceof AbstractAxialFluidPipe) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)AbstractAxialFluidPipe.field_10927);
            return new PipeConnections(EnumSet.of(facing, facing.method_10153()));
        }
        return PipeConnections.EMPTY;
    }

    default public void removePipe(class_3218 world, class_2680 state, class_2338 pos) {
        FluidNodeManagerImpl.removeStorageNodes((class_1937)world, pos);
    }

    default public boolean connectInDirection(class_1922 world, class_2338 pos, class_2680 state, class_2350 direction) {
        return true;
    }

    default public AcceptorModes getDirectionMode(class_1937 world, class_2338 pos, class_2680 state, class_2350 direction) {
        return AcceptorModes.INSERT_EXTRACT;
    }

    @Override
    default public FluidPipeVertex getPipeVertex(class_3218 world, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FluidPipeBlockEntity) {
            FluidPipeBlockEntity be = (FluidPipeBlockEntity)class_25862;
            be.getPipeVertex().updateNodes(world, pos.method_10062(), state);
            return be.getPipeVertex();
        }
        return null;
    }

    default public PipeCol getCol(class_1937 world, class_2338 pos, class_2680 blockState) {
        return PipeCol.ANY;
    }

    public static enum PipeCol {
        ANY(class_1767.field_7952),
        WHITE(class_1767.field_7952),
        ORANGE(class_1767.field_7946),
        MAGENTA(class_1767.field_7958),
        LIGHT_BLUE(class_1767.field_7951),
        YELLOW(class_1767.field_7947),
        LIME(class_1767.field_7961),
        PINK(class_1767.field_7954),
        GRAY(class_1767.field_7944),
        LIGHT_GRAY(class_1767.field_7967),
        CYAN(class_1767.field_7955),
        PURPLE(class_1767.field_7945),
        BLUE(class_1767.field_7966),
        BROWN(class_1767.field_7957),
        GREEN(class_1767.field_7942),
        RED(class_1767.field_7964),
        BLACK(class_1767.field_7963);

        public final class_1767 dyeCol;

        private PipeCol(class_1767 dyeCol) {
            this.dyeCol = dyeCol;
        }

        public static PipeCol get(class_1767 dyeCol) {
            return PipeCol.values()[dyeCol.ordinal() + 1];
        }

        public boolean matches(PipeCol other) {
            return this == ANY || other == ANY || this == other;
        }

        public int hexCode() {
            return this.dyeCol.method_7790();
        }
    }
}

