/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.api.pipe;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.neep.meatlib.block.BaseBlock;
import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.transport.fluid_network.ConnectionType;
import com.neep.neepmeat.transport.fluid_network.SimplePipeProperties;
import com.neep.neepmeat.util.NMMaths;
import com.neep.neepmeat.util.NMVec2f;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public abstract class PrecisePipeBlock
extends BaseBlock
implements class_3737 {
    public static final class_2754<ConnectionType> NORTH_CONNECTION = SimplePipeProperties.NORTH_CONNECTION;
    public static final class_2754<ConnectionType> EAST_CONNECTION = SimplePipeProperties.EAST_CONNECTION;
    public static final class_2754<ConnectionType> SOUTH_CONNECTION = SimplePipeProperties.SOUTH_CONNECTION;
    public static final class_2754<ConnectionType> WEST_CONNECTION = SimplePipeProperties.WEST_CONNECTION;
    public static final class_2754<ConnectionType> UP_CONNECTION = SimplePipeProperties.UP_CONNECTION;
    public static final class_2754<ConnectionType> DOWN_CONNECTION = SimplePipeProperties.DOWN_CONNECTION;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private final Map<class_2680, class_265> shapes = Maps.newHashMap();
    public static final Map<class_2350, class_2754<ConnectionType>> DIR_TO_CONNECTION = (Map)class_156.method_656(() -> {
        EnumMap<class_2350, class_2754<ConnectionType>> map = new EnumMap<class_2350, class_2754<ConnectionType>>(class_2350.class);
        map.put(class_2350.field_11043, NORTH_CONNECTION);
        map.put(class_2350.field_11034, EAST_CONNECTION);
        map.put(class_2350.field_11035, SOUTH_CONNECTION);
        map.put(class_2350.field_11039, WEST_CONNECTION);
        map.put(class_2350.field_11033, DOWN_CONNECTION);
        map.put(class_2350.field_11036, UP_CONNECTION);
        return map;
    });
    public static final Map<class_2350, class_265> DIR_SHAPES = new ImmutableMap.Builder().put((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)5.0)).put((Object)class_2350.field_11034, (Object)class_2248.method_9541((double)11.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)).put((Object)class_2350.field_11035, (Object)class_2248.method_9541((double)4.0, (double)4.0, (double)11.0, (double)12.0, (double)12.0, (double)16.0)).put((Object)class_2350.field_11039, (Object)class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)12.0)).put((Object)class_2350.field_11036, (Object)class_2248.method_9541((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)).put((Object)class_2350.field_11033, (Object)class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0)).build();
    private static final class_2350[] HORIZONTAL = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};

    public PrecisePipeBlock(RegistrationContext ctx, ItemSettings itemSettings, class_4970.class_2251 settings) {
        super(ctx, itemSettings, settings.method_51369());
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(NORTH_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657(EAST_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657(SOUTH_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657(WEST_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657(UP_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657(DOWN_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        for (class_2680 state : this.method_9595().method_11662()) {
            this.shapes.put(state, this.getShapeForState(state));
        }
    }

    public class_2754<ConnectionType> getConnection(class_2350 direction) {
        return DIR_TO_CONNECTION.get(direction);
    }

    public ConnectionType getConnection(class_2680 state, class_2350 face) {
        return (ConnectionType)((Object)state.method_11654(this.getConnection(face)));
    }

    protected class_265 getCentreShape() {
        return class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    }

    public class_265 getShapeForState(class_2680 state) {
        class_265 shape = this.getCentreShape();
        for (class_2350 direction : class_2350.values()) {
            if (state.method_11654((class_2769)DIR_TO_CONNECTION.get(direction)) != ConnectionType.SIDE) continue;
            shape = class_259.method_1084((class_265)shape, (class_265)DIR_SHAPES.get(direction));
        }
        return shape;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_265 method_26159(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapes.get(state);
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 context) {
        return this.shapes.get(state);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        return this.getConnectedState((class_1922)world, this.method_9564(), pos, ctx.method_8038().method_10153(), ctx.method_8036() != null && !ctx.method_8036().method_5715());
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        boolean connection = this.canConnectTo(state, neighborState, direction.method_10153(), (class_1937)world, neighborPos, false);
        if (connection && ((ConnectionType)((Object)state.method_11654((class_2769)DIR_TO_CONNECTION.get(direction)))).isConnected()) {
            return (class_2680)state.method_11657((class_2769)DIR_TO_CONNECTION.get(direction), (Comparable)((Object)ConnectionType.SIDE));
        }
        return (class_2680)state.method_11657((class_2769)DIR_TO_CONNECTION.get(direction), (Comparable)((Object)ConnectionType.NONE));
    }

    public abstract boolean canConnectTo(class_2680 var1, class_2680 var2, class_2350 var3, class_1937 var4, class_2338 var5, boolean var6);

    protected class_2680 getConnectedState(class_1922 world, class_2680 state, class_2338 pos, class_2350 side, boolean newConnection) {
        class_2338 offsetPos = pos.method_10093(side);
        class_2680 offsetState = world.method_8320(offsetPos);
        if (this.canConnectTo(state, offsetState, side.method_10153(), (class_1937)world, offsetPos, true)) {
            state = (class_2680)state.method_11657(this.getConnection(side), (Comparable)((Object)ConnectionType.SIDE));
        }
        if (newConnection) {
            for (class_2350 direction : class_2350.values()) {
                class_2680 adjState;
                class_2338 adjPos = pos.method_10093(direction);
                boolean adjacentConnections = this.adjacentAutoConnect((class_1937)world, adjPos, adjState = world.method_8320(adjPos), state, direction);
                if (!adjacentConnections) continue;
                state = (class_2680)state.method_11657(this.getConnection(direction), (Comparable)((Object)ConnectionType.SIDE));
            }
        }
        return (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(pos).method_15772() == class_3612.field_15910));
    }

    protected abstract boolean adjacentAutoConnect(class_1937 var1, class_2338 var2, class_2680 var3, class_2680 var4, class_2350 var5);

    protected boolean handCanChangeConnections(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_1268 hand, class_2350 changeDirection) {
        class_1799 stack = player.method_5998(hand);
        return hand != class_1268.field_5810 && (stack.method_7960() || stack.method_31573(NMTags.WRENCH));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_243 hitPos;
        class_2350 changeDirection;
        class_2350 direction = hit.method_17780();
        if (player.method_5715()) {
            direction = direction.method_10153();
        }
        if (!this.handCanChangeConnections(world, pos, state, player, hand, changeDirection = PrecisePipeBlock.getUseDirection(direction, pos, hitPos = hit.method_17784()))) {
            return class_1269.field_5811;
        }
        boolean connected = ((ConnectionType)((Object)state.method_11654(this.getConnection(changeDirection)))).isConnected();
        this.connect(world, pos, state, player, changeDirection, connected ? ConnectionType.NONE : ConnectionType.SIDE);
        return class_1269.field_5812;
    }

    public void connect(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_2350 face, ConnectionType connectionType) {
        class_2680 newState = (class_2680)state.method_11657(this.getConnection(face), (Comparable)((Object)connectionType));
        world.method_8501(pos, newState);
        world.method_8396(null, pos, this.connectionChangeSound(world, state, pos), class_3419.field_15245, 1.0f, 1.0f);
        this.onConnectionUpdate(world, state, newState, pos, player);
    }

    public static class_2350 getUseDirection(class_2350 direction, class_2338 pos, class_243 hitPos) {
        NMVec2f relative = NMMaths.removeAxis(direction.method_10166(), hitPos.method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
        class_2350 changeDirection = direction;
        if (!relative.isWithin(0.5f, 0.5f, 0.25f)) {
            if ((double)relative.getY() > 0.75) {
                changeDirection = class_2350.field_11035;
            }
            if ((double)relative.getY() < 0.25) {
                changeDirection = class_2350.field_11043;
            }
            if ((double)relative.getX() < 0.25) {
                changeDirection = class_2350.field_11033;
            }
            if ((double)relative.getX() > 0.75) {
                changeDirection = class_2350.field_11036;
            }
            switch (direction.method_10166()) {
                case field_11052: {
                    changeDirection = changeDirection.method_35833(class_2350.class_2351.field_11051);
                    break;
                }
                case field_11051: {
                    changeDirection = NMMaths.swapDirections(changeDirection.method_35833(class_2350.class_2351.field_11052));
                }
            }
        }
        return changeDirection;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467 -> state;
            case class_2470.field_11463 -> this.rotate(state, 1);
            case class_2470.field_11464 -> this.rotate(state, 2);
            case class_2470.field_11465 -> this.rotate(state, 3);
        };
    }

    private class_2680 rotate(class_2680 oldState, int offset) {
        class_2680 newState = oldState;
        for (int i = 0; i < HORIZONTAL.length; ++i) {
            class_2350 newDirection = HORIZONTAL[(i + offset) % HORIZONTAL.length];
            newState = (class_2680)newState.method_11657(this.getConnection(newDirection), (Comparable)((Object)((ConnectionType)((Object)oldState.method_11654(this.getConnection(HORIZONTAL[i]))))));
        }
        return newState;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            default -> throw new IncompatibleClassChangeError();
            case class_2415.field_11302 -> state;
            case class_2415.field_11300 -> this.mirrorZ(state);
            case class_2415.field_11301 -> this.mirrorX(state);
        };
    }

    private class_2680 mirrorX(class_2680 state) {
        ConnectionType oldEast = (ConnectionType)((Object)state.method_11654(this.getConnection(class_2350.field_11034)));
        state = (class_2680)((class_2680)state.method_11657(this.getConnection(class_2350.field_11034), (Comparable)((Object)((ConnectionType)((Object)state.method_11654(this.getConnection(class_2350.field_11039))))))).method_11657(this.getConnection(class_2350.field_11039), (Comparable)((Object)oldEast));
        return state;
    }

    private class_2680 mirrorZ(class_2680 state) {
        ConnectionType oldNorth = (ConnectionType)((Object)state.method_11654(this.getConnection(class_2350.field_11043)));
        state = (class_2680)((class_2680)state.method_11657(this.getConnection(class_2350.field_11043), (Comparable)((Object)((ConnectionType)((Object)state.method_11654(this.getConnection(class_2350.field_11035))))))).method_11657(this.getConnection(class_2350.field_11035), (Comparable)((Object)oldNorth));
        return state;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH_CONNECTION, EAST_CONNECTION, SOUTH_CONNECTION, WEST_CONNECTION, UP_CONNECTION, DOWN_CONNECTION, WATERLOGGED});
    }

    public void onConnectionUpdate(class_1937 world, class_2680 state, class_2680 newState, class_2338 pos, class_1657 entity) {
    }

    public class_3414 connectionChangeSound(class_1937 world, class_2680 state, class_2338 pos) {
        return NMSounds.WRENCH_CLICK;
    }

    public boolean method_22358(class_2680 state, class_3611 fluid) {
        return false;
    }
}

