/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.api.pipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.neep.neepmeat.transport.api.pipe.PrecisePipeBlock;
import com.neep.neepmeat.transport.api.pipe.VascularConduitEntity;
import com.neep.neepmeat.transport.blood_network.BloodNetwork;
import com.neep.neepmeat.transport.blood_network.BloodNetworkManager;
import com.neep.neepmeat.transport.fluid_network.ConnectionType;
import java.util.ArrayList;
import java.util.HashSet;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public interface VascularConduit {
    public static final BlockApiLookup<VascularConduit, Void> LOOKUP = BlockApiLookup.get((class_2960)new class_2960("neepmeat", "vascular_conduit"), VascularConduit.class, Void.class);

    public static VascularConduit find(class_1937 world, class_2338 pos, class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof VascularConduit) {
            VascularConduit conduit = (VascularConduit)class_22482;
            return conduit;
        }
        return (VascularConduit)LOOKUP.find(world, pos, null);
    }

    public static boolean isConnected(class_1920 blockView, class_2338 pos, class_2680 state, class_2350 direction) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof VascularConduit) {
            VascularConduit conduit = (VascularConduit)class_22482;
            return conduit.isConnectedIn((class_1922)blockView, pos, state, direction);
        }
        return false;
    }

    default public void updatePosition(class_1937 world, class_2338 pos, class_2680 state, VascularConduitEntity.UpdateReason reason) {
        if (world.method_8608()) {
            return;
        }
        switch (reason) {
            case ADDED: {
                ArrayList adjNetworks = Lists.newArrayList();
                class_2338.class_2339 mutable = pos.method_25503();
                for (class_2350 direction : class_2350.values()) {
                    if (!this.isConnectedIn((class_1922)world, pos, state, direction)) continue;
                    mutable.method_25505((class_2382)pos, direction);
                    BloodNetwork network = BloodNetwork.find(world, (class_2338)mutable);
                    if (network == null) continue;
                    adjNetworks.add(network);
                }
                if (adjNetworks.isEmpty()) {
                    BloodNetwork network = BloodNetworkManager.get(world).create(pos);
                    network.add(pos, this.getEntity(world, pos, state));
                    break;
                }
                if (adjNetworks.size() == 1) {
                    ((BloodNetwork)adjNetworks.get(0)).add(pos, this.getEntity(world, pos, state));
                    break;
                }
                ((BloodNetwork)adjNetworks.get(0)).add(pos, this.getEntity(world, pos, state));
                ((BloodNetwork)adjNetworks.get(0)).merge(adjNetworks);
                break;
            }
            case REMOVED: {
                BloodNetwork original = BloodNetwork.find(world, pos);
                if (original != null) {
                    original.remove(pos, this.getEntity(world, pos, state));
                }
                HashSet updatedNetworks = Sets.newHashSet();
                class_2338.class_2339 mutable = pos.method_25503();
                for (class_2350 direction : class_2350.values()) {
                    if (!this.isConnectedIn((class_1922)world, pos, state, direction)) continue;
                    mutable.method_25505((class_2382)pos, direction);
                    VascularConduit conduit = VascularConduit.find(world, (class_2338)mutable, world.method_8320((class_2338)mutable));
                    BloodNetwork network = BloodNetwork.find(world, (class_2338)mutable);
                    if (conduit == null) continue;
                    if (network != null) {
                        if (updatedNetworks.contains(network)) continue;
                        updatedNetworks.add(network);
                        network.rebuild(mutable.method_10062(), reason);
                        continue;
                    }
                    BloodNetwork newNetwork = BloodNetworkManager.get(world).create((class_2338)mutable);
                    newNetwork.rebuild(mutable.method_10062(), reason);
                }
                break;
            }
            case CHANGED: {
                BloodNetwork network = BloodNetwork.find(world, pos);
                if (network == null) break;
                network.update(pos, this.getEntity(world, pos, state));
            }
        }
    }

    default public boolean isConnectedIn(class_1922 world, class_2338 pos, class_2680 state, class_2350 direction) {
        if (state.method_26204() instanceof PrecisePipeBlock) {
            return ((ConnectionType)((Object)state.method_11654((class_2769)PrecisePipeBlock.DIR_TO_CONNECTION.get(direction)))).isConnected();
        }
        return false;
    }

    public VascularConduitEntity getEntity(class_1937 var1, class_2338 var2, class_2680 var3);
}

