/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.energy_transport.entity.vsc;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepbus.block.entity.ConfigProvider;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.SimpleEntry;
import com.neep.neepbus.util.WritePort;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.transport.api.pipe.AbstractBloodAcceptor;
import com.neep.neepmeat.transport.api.pipe.BalancingBloodAcceptor;
import com.neep.neepmeat.transport.api.pipe.BloodAcceptor;
import com.neep.neepmeat.transport.block.energy_transport.VSCBlock;
import com.neep.neepmeat.transport.block.energy_transport.entity.vsc.VSCMode;
import com.neep.neepmeat.transport.blood_network.BloodTransferChangeListener;
import com.neep.neepmeat.transport.screen.VSCScreenHandler;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class VSCBlockEntity
extends SyncableBlockEntity
implements ExtendedScreenHandlerFactory,
ConfigProvider {
    private final WritePort inputPort = data -> this.setDesiredPower(data.intValue());
    private final NeepBusConfig config = NeepBusConfig.builder(this::method_5431).input(new SimpleEntry("Power"), this.inputPort).applyChanges(this).build();
    protected long powerToSource;
    private final LazyBlockApiCache<BloodAcceptor, class_2350> cache;
    private long powerToSink;
    protected final AbstractBloodAcceptor normalSink = new NormalSinkAcceptor();
    protected final BloodAcceptor normalSource = new NormalSourceAcceptor();
    protected final AbstractBloodAcceptor balanceSink = new BalancingSinkAcceptor();
    protected final BloodAcceptor balanceSource = new BalancingSourceAcceptor();
    protected int desiredPower = 0;
    protected boolean activeWithRedstone = false;
    private int priority;
    private boolean cutOff = false;

    public VSCBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.cache = LazyBlockApiCache.of(BloodAcceptor.SIDED, this.field_11867.method_10093((class_2350)this.method_11010().method_11654((class_2769)VSCBlock.field_10927)), () -> ((VSCBlockEntity)this).method_10997(), () -> ((class_2350)this.method_11010().method_11654((class_2769)VSCBlock.field_10927)).method_10153());
    }

    public BloodAcceptor getBloodAcceptor(class_2350 face) {
        if (this.method_11010().method_11654((class_2769)VSCBlock.field_10927) == face) {
            return this.getSourceAcceptor();
        }
        return this.getSinkAcceptor();
    }

    protected BloodAcceptor getSourceAcceptor() {
        return this.mode() == VSCMode.NORMAL ? this.normalSource : this.balanceSource;
    }

    protected AbstractBloodAcceptor getSinkAcceptor() {
        return this.mode() == VSCMode.NORMAL ? this.normalSink : this.balanceSink;
    }

    public boolean isActive() {
        return (Boolean)this.method_11010().method_11654((class_2769)VSCBlock.ACTIVE);
    }

    public void setDesiredPower(int power) {
        if (this.desiredPower != (power = Math.max(0, power))) {
            this.desiredPower = power;
            BloodTransferChangeListener network = this.getSinkAcceptor().getNetwork();
            if (network != null) {
                network.updateTransfer(null);
            }
        }
    }

    public int getDesiredPower() {
        return this.desiredPower;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("desired_power", this.desiredPower);
        nbt.method_10569("priority", this.priority);
        nbt.method_10556("active_with_redstone", this.activeWithRedstone);
        nbt.method_10556("cut_off", this.cutOff);
        nbt.method_10566("config", (class_2520)this.config.writeNbt(new class_2487()));
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.desiredPower = nbt.method_10550("desired_power");
        this.priority = nbt.method_10550("priority");
        this.activeWithRedstone = nbt.method_10577("active_with_redstone");
        this.cutOff = nbt.method_10577("cut_off");
        this.config.readNbt(nbt.method_10562("config"));
    }

    private void updateBalance(VSCMode balance) {
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(VSCBlock.MODE, (Comparable)((Object)balance)));
        }
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.writeInt(this.desiredPower);
    }

    public class_2561 method_5476() {
        return class_2561.method_30163((String)"Vascular Source Converter");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new VSCScreenHandler(inv, syncId, this);
    }

    public void method_11012() {
        super.method_11012();
    }

    public void updateState(int power) {
        boolean nextActive;
        boolean prevActive = (Boolean)this.method_11010().method_11654((class_2769)VSCBlock.ACTIVE);
        boolean bl = nextActive = power > 0 == this.activeWithRedstone;
        if (nextActive != prevActive) {
            this.updateActive(nextActive);
        }
        this.updateFrontAcceptor();
    }

    private void updateActive(boolean nextActive) {
        this.method_10997().method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)VSCBlock.ACTIVE, (Comparable)Boolean.valueOf(nextActive)));
        BloodTransferChangeListener network = this.getSinkAcceptor().getNetwork();
        if (network != null) {
            network.updateTransfer(null);
        }
    }

    public void updateFrontAcceptor() {
        BloodAcceptor found = this.cache.find();
        if (found != null) {
            found.updateInflux((float)this.powerToSource / (float)PowerUtils.referencePower());
            found.setChangeListener(this::changed);
        }
    }

    public void changed(@Nullable BloodAcceptor changed) {
        BloodTransferChangeListener sinkListener = this.getSinkAcceptor().getNetwork();
        if (sinkListener != null) {
            sinkListener.updateTransfer(null);
        }
    }

    public void changeMode() {
        this.activeWithRedstone = !this.activeWithRedstone;
        this.updateState(this.method_10997().method_49804(this.field_11867));
        this.method_5431();
    }

    public void setMode(VSCMode mode) {
        this.updateBalance(mode);
        this.method_5431();
    }

    @Override
    public NeepBusConfig getConfig() {
        return this.config;
    }

    public void invalidatePortCache() {
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.method_5431();
    }

    public VSCMode mode() {
        return (VSCMode)((Object)this.method_11010().method_11654(VSCBlock.MODE));
    }

    public boolean cutOff() {
        return this.cutOff;
    }

    public void setProperties(int power, int priority, boolean cutOff, VSCMode mode) {
        this.desiredPower = power;
        this.priority = priority;
        this.cutOff = cutOff;
        this.setMode(mode);
        this.updateActive(this.isActive());
        this.method_5431();
    }

    private class NormalSinkAcceptor
    extends AbstractBloodAcceptor {
        private NormalSinkAcceptor() {
        }

        @Override
        public BloodAcceptor.Mode getMode() {
            return BloodAcceptor.Mode.ACTIVE_SINK;
        }

        @Override
        public float updateInflux(float influx) {
            long absInflux = (long)(influx * (float)PowerUtils.BASE_POWER);
            if (VSCBlockEntity.this.isActive() && (absInflux >= (long)VSCBlockEntity.this.desiredPower || !VSCBlockEntity.this.cutOff)) {
                long minimum;
                VSCBlockEntity.this.powerToSource = minimum = Math.min(absInflux, (long)VSCBlockEntity.this.desiredPower);
                VSCBlockEntity.this.updateFrontAcceptor();
                return (float)minimum / (float)PowerUtils.BASE_POWER;
            }
            VSCBlockEntity.this.powerToSource = 0L;
            VSCBlockEntity.this.updateFrontAcceptor();
            return 0.0f;
        }
    }

    private class NormalSourceAcceptor
    implements BloodAcceptor {
        private NormalSourceAcceptor() {
        }

        @Override
        public BloodAcceptor.Mode getMode() {
            return BloodAcceptor.Mode.SOURCE;
        }

        @Override
        public long getOutput() {
            return VSCBlockEntity.this.powerToSource;
        }
    }

    private class BalancingSinkAcceptor
    extends AbstractBloodAcceptor
    implements BalancingBloodAcceptor {
        private BalancingSinkAcceptor() {
        }

        @Override
        public long update(long internalAbs) {
            if (VSCBlockEntity.this.isActive()) {
                if (VSCBlockEntity.this.powerToSink < 0L) {
                    if (internalAbs >= (long)VSCBlockEntity.this.desiredPower || !VSCBlockEntity.this.cutOff) {
                        long minimum;
                        VSCBlockEntity.this.powerToSource = minimum = Math.min(internalAbs, (long)VSCBlockEntity.this.desiredPower);
                        return -minimum;
                    }
                    VSCBlockEntity.this.powerToSource = 0L;
                    return 0L;
                }
                VSCBlockEntity.this.powerToSource = VSCBlockEntity.this.desiredPower;
                return VSCBlockEntity.this.powerToSink;
            }
            return 0L;
        }

        @Override
        public int priority() {
            return 0;
        }
    }

    private class BalancingSourceAcceptor
    implements BalancingBloodAcceptor {
        private BalancingSourceAcceptor() {
        }

        @Override
        public long update(long internalAbs) {
            if (VSCBlockEntity.this.isActive()) {
                VSCBlockEntity.this.powerToSink = internalAbs - (long)VSCBlockEntity.this.desiredPower;
                if (VSCBlockEntity.this.powerToSink > 0L) {
                    return -VSCBlockEntity.this.powerToSink;
                }
                if (internalAbs < (long)VSCBlockEntity.this.desiredPower) {
                    return VSCBlockEntity.this.powerToSource;
                }
            } else {
                VSCBlockEntity.this.powerToSource = 0L;
            }
            return 0L;
        }

        @Override
        public int priority() {
            return VSCBlockEntity.this.desiredPower;
        }
    }
}

