/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.fluid_transport;

import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.item.FluidComponentItem;
import com.neep.neepmeat.transport.api.pipe.AbstractAxialFluidPipe;
import com.neep.neepmeat.transport.block.fluid_transport.entity.FilterPipeBlockEntity;
import com.neep.neepmeat.transport.block.fluid_transport.machine.FluidPipeBlockEntity;
import com.neep.neepmeat.transport.fluid_network.node.BlockFluidPipeVertex;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class FilterPipeBlock
extends AbstractAxialFluidPipe
implements class_2343 {
    public FilterPipeBlock(RegistrationContext ctx, ItemSettings itemSettings, class_4970.class_2251 settings) {
        super(ctx, itemSettings.factory(FluidComponentItem::new), settings.method_22488());
        this.method_9590((class_2680)this.method_9595().method_11664());
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        FilterPipeBlockEntity be = world.method_35230(pos, NMBlockEntities.FILTER_PIPE).orElse(null);
        if (be == null) {
            NeepMeat.LOGGER.error("Filter pipe block entity has been removed.");
        }
        class_1799 stack = player.method_5998(hand);
        if (!world.method_8608() && be != null) {
            Storage storage = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand));
            if (player.method_5715()) {
                be.setFilterFluid(FluidVariant.blank());
            }
            if (storage != null) {
                try (Transaction transaction = Transaction.openOuter();){
                    FluidVariant variant = (FluidVariant)StorageUtil.findExtractableResource((Storage)storage, (TransactionContext)transaction);
                    if (variant != null && !variant.isBlank()) {
                        be.setFilterFluid(variant);
                    }
                    transaction.commit();
                }
            }
            FilterPipeBlock.sendMessage(player, be.getFilterVariant());
        }
        if (world.method_8608()) {
            world.method_16109(pos, state, state);
        }
        return class_1269.method_29236((boolean)world.field_9236);
    }

    public static void sendMessage(class_1657 player, FluidVariant variant) {
        player.method_7353((class_2561)class_2561.method_43469((String)"message.neepmeat.filter_pipe.filter", (Object[])new Object[]{FluidVariantAttributes.getName((FluidVariant)variant)}), true);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FilterPipeBlockEntity(pos, state);
    }

    @Environment(value=EnvType.CLIENT)
    public static int getTint(class_2680 state, class_1920 world, class_2338 pos, int index) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FilterPipeBlockEntity) {
            FilterPipeBlockEntity be = (FilterPipeBlockEntity)class_25862;
            return FluidVariantRendering.getColor((FluidVariant)be.getFilterVariant());
        }
        return 0;
    }

    public static class FilterFluidPipeVertex
    extends BlockFluidPipeVertex {
        public FilterFluidPipeVertex(FluidPipeBlockEntity<FilterFluidPipeVertex> fluidPipeBlockEntity) {
            super(fluidPipeBlockEntity);
        }

        @Override
        public long canInsert(class_3218 world, int inDir, FluidVariant variant, long maxAmount) {
            FluidPipeBlockEntity fluidPipeBlockEntity = this.parent;
            if (fluidPipeBlockEntity instanceof FilterPipeBlockEntity) {
                FilterPipeBlockEntity be = (FilterPipeBlockEntity)fluidPipeBlockEntity;
                return be.getFilterVariant().isBlank() || variant.equals(be.getFilterVariant()) ? maxAmount : 0L;
            }
            return 0L;
        }

        @Override
        public boolean canSimplify() {
            return false;
        }
    }
}

