/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.fluid_transport.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.storage.FluidBuffer;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.fluid.PersistentFluid;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.transport.block.fluid_transport.machine.TankBlockEntity;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class FluidDrainBlockEntity
extends SyncableBlockEntity
implements FluidBuffer.FluidBufferProvider {
    private int transferCooldown = 0;
    protected final WritableSingleFluidStorage buffer = new WritableSingleFluidStorage(648000L, this::method_5431);

    public FluidDrainBlockEntity(class_2338 pos, class_2680 state) {
        super(NMBlockEntities.FLUID_DRAIN, pos, state);
    }

    public boolean needsCooldown() {
        return this.transferCooldown > 0;
    }

    private void setCooldown(int cooldown) {
        this.transferCooldown = cooldown;
    }

    @Nullable
    public WritableSingleFluidStorage getBuffer(class_2350 direction) {
        return this.buffer;
    }

    public boolean grabFluid(class_1937 world, class_2338 pos, class_2680 state) {
        class_2338 upPos = pos.method_10084();
        class_2338 sourcePos = this.findFluid(world, upPos, state);
        if (sourcePos != null) {
            class_3610 fluidState = world.method_8316(sourcePos);
            try (Transaction transaction = Transaction.openOuter();){
                class_2680 fluidBlockState = world.method_8320(sourcePos);
                long targetAmount = (long)fluidState.method_15761() * 81000L / 8L;
                long transferred = this.buffer.insert(FluidVariant.of((class_3611)((class_3609)fluidState.method_15772()).method_15751()), targetAmount, (TransactionContext)transaction);
                if (transferred >= targetAmount) {
                    class_2248 class_22482 = fluidBlockState.method_26204();
                    if (class_22482 instanceof class_2263) {
                        class_2263 drainable = (class_2263)class_22482;
                        drainable.method_9700((class_1936)world, sourcePos, fluidBlockState);
                        transaction.commit();
                    } else if (fluidBlockState.method_26204() instanceof class_2404) {
                        world.method_8501(sourcePos, class_2246.field_10124.method_9564());
                        transaction.commit();
                    }
                }
            }
        }
        return true;
    }

    protected class_2338 findFluid(class_1937 world, class_2338 origin, class_2680 state) {
        class_3610 originState = world.method_8316(origin);
        if (originState.method_15769()) {
            return null;
        }
        if (originState.method_15771()) {
            return origin;
        }
        class_3611 class_36112 = originState.method_15772();
        if (class_36112 instanceof PersistentFluid) {
            PersistentFluid persistentFluid = (PersistentFluid)class_36112;
            return origin;
        }
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayDeque<class_2338> frontier = new ArrayDeque<class_2338>();
        frontier.add(origin);
        for (int i = 0; i < 8; ++i) {
            while (!frontier.isEmpty()) {
                class_2338 current = (class_2338)frontier.poll();
                visited.add(current);
                for (class_2350 direction : class_2350.values()) {
                    class_2338 newPos = current.method_10093(direction);
                    class_3610 fluidState = world.method_8316(newPos);
                    if (visited.contains(newPos) || fluidState.method_15769()) continue;
                    if (fluidState.method_15771()) {
                        return newPos;
                    }
                    frontier.add(newPos);
                }
            }
        }
        return null;
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, FluidDrainBlockEntity blockEntity) {
        --blockEntity.transferCooldown;
        if (!blockEntity.needsCooldown()) {
            blockEntity.setCooldown(16);
            blockEntity.grabFluid(world, pos, state);
        }
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.buffer.toNbt(tag);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.buffer.readNbt(tag);
    }

    public boolean onUse(class_1657 player, class_1268 hand) {
        if (WritableSingleFluidStorage.handleInteract((Storage<FluidVariant>)this.buffer, this.field_11863, player, hand)) {
            return true;
        }
        if (!this.field_11863.method_8608()) {
            TankBlockEntity.showContents((class_3222)player, this.field_11863, this.method_11016(), this.getBuffer(null));
            return true;
        }
        return true;
    }
}

