/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.blood_network;

import com.google.common.collect.Queues;
import com.neep.neepmeat.transport.TransportComponents;
import com.neep.neepmeat.transport.api.BlockEntityUnloadListener;
import com.neep.neepmeat.transport.api.pipe.VascularConduitEntity;
import com.neep.neepmeat.transport.api.pipe.VascularConduitEntityProvider;
import com.neep.neepmeat.transport.blood_network.BloodNetwork;
import com.neep.neepmeat.transport.blood_network.BloodNetworkChunkComponent;
import com.neep.neepmeat.transport.blood_network.ConduitBloodNetwork;
import com.neep.neepmeat.transport.event.WorldChunkEvents;
import com.neep.neepmeat.transport.interfaces.IServerWorld;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

public class BloodNetworkManager
extends class_18 {
    public static final String NAME = "neepmeatblood_networks";
    private final Object2ObjectMap<UUID, BloodNetwork> tickingNetworks = new Object2ObjectOpenHashMap();
    private final class_3218 world;
    private final Queue<Runnable> stagedEvents = Queues.newArrayDeque();

    public BloodNetworkManager(class_3218 world) {
        this.world = world;
    }

    public BloodNetworkManager(class_3218 world, class_2487 nbt) {
        this.world = world;
        this.readNbt(nbt);
    }

    public BloodNetwork create(class_2338 pos) {
        ConduitBloodNetwork network = new ConduitBloodNetwork(UUID.randomUUID(), this.world);
        this.tickingNetworks.put((Object)network.getUUID(), (Object)network);
        return network;
    }

    private void tick() {
        while (!this.stagedEvents.isEmpty()) {
            Runnable event = this.stagedEvents.poll();
            event.run();
        }
        ObjectIterator it = this.tickingNetworks.entrySet().iterator();
        while (it.hasNext()) {
            BloodNetwork network = (BloodNetwork)((Map.Entry)it.next()).getValue();
            if (network.isRemoved()) {
                it.remove();
                continue;
            }
            network.tick();
            if (!network.isDirty()) continue;
            network.resetDirty();
        }
    }

    public static BloodNetworkManager get(class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            return ((IServerWorld)serverWorld).getBloodNetworkManager();
        }
        throw new IllegalArgumentException("Blood network manager must only be used on the logical server.");
    }

    protected void readNbt(class_2487 nbt) {
    }

    public class_2487 method_75(class_2487 nbt) {
        return nbt;
    }

    public void stageEvent(Runnable runnable) {
        this.stagedEvents.add(runnable);
    }

    public static void init() {
        WorldChunkEvents.BE_SET_WORLD.register((chunk, be) -> {
            if (be instanceof VascularConduitEntityProvider) {
                VascularConduitEntityProvider conduit = (VascularConduitEntityProvider)be;
                BloodNetworkChunkComponent component = (BloodNetworkChunkComponent)chunk.getComponent(TransportComponents.BLOOD_NETWORK);
                component.register(conduit.get());
            }
        });
        WorldChunkEvents.BE_MANUAL_REMOVE.register((chunk, be) -> {
            if (be instanceof VascularConduitEntityProvider) {
                VascularConduitEntityProvider conduit = (VascularConduitEntityProvider)be;
                BloodNetworkChunkComponent component = (BloodNetworkChunkComponent)chunk.getComponent(TransportComponents.BLOOD_NETWORK);
                component.unregister(conduit.get());
            }
        });
        WorldChunkEvents.UNLOAD_ENTITIES.register(chunk -> chunk.method_12214().values().forEach(be -> {
            if (be instanceof BlockEntityUnloadListener) {
                BlockEntityUnloadListener listener = (BlockEntityUnloadListener)be;
                listener.onUnload(chunk);
            }
        }));
        ServerTickEvents.END_WORLD_TICK.register(world -> BloodNetworkManager.get((class_1937)world).tick());
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            BloodNetworkManager manager = BloodNetworkManager.get((class_1937)world);
            BloodNetworkChunkComponent component = (BloodNetworkChunkComponent)TransportComponents.BLOOD_NETWORK.get((Object)chunk);
            manager.stageEvent(() -> {
                Map map = component.getPipes().asMap();
                map.forEach((uuid, pipes) -> ((BloodNetwork)manager.tickingNetworks.computeIfAbsent(uuid, u -> new ConduitBloodNetwork((UUID)uuid, world))).insert((Collection<VascularConduitEntity>)pipes));
                component.loaded = true;
            });
        });
    }

    record NetworkEntry(BloodNetwork network, Set<UUID> container) {
        public UUID uuid() {
            return this.network.getUUID();
        }
    }
}

