/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.client.screen;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.primitive.Point;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.meatlib.client.screen.widget.ClickableWidget;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.util.BorderScrollRight;
import com.neep.neepmeat.transport.network.SyncRequesterScreenS2CPacket;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_918;

public class ItemPane
implements ClickableWidget,
Rectangle.Mutable {
    protected int x;
    protected int y;
    protected int gridStartX;
    protected int gridStartY;
    protected final int gridColumns;
    protected final int gridRows;
    protected int w;
    protected int h;
    protected final class_918 itemRenderer;
    protected final class_327 textRenderer;
    protected final List<ResourceAmount<ItemVariant>> items;
    protected final class_310 client;
    protected final int wSlot = 18;
    protected final int hSlot = 18;
    private final SearchWidget searchWidget;
    protected List<class_1799> itemsToShow = List.of();
    protected int scrollRow;
    private BorderScrollRight border;
    private int scrollableRows;
    private boolean searchMode;

    public ItemPane(int gridColumns, int gridRows, class_918 itemRenderer, class_327 textRenderer, List<ResourceAmount<ItemVariant>> items, class_310 client) {
        this.gridColumns = gridColumns;
        this.gridRows = gridRows;
        this.itemRenderer = itemRenderer;
        this.textRenderer = textRenderer;
        this.items = items;
        this.client = client;
        this.searchWidget = new SearchWidget();
        this.h = gridRows * 18 + this.searchWidget.h() + 6;
        this.updateSearch();
    }

    public void updateSearch() {
        this.itemsToShow = this.items.stream().map(i -> ((ItemVariant)i.resource()).toStack((int)i.amount())).filter(s -> s.method_7964().getString().toLowerCase().contains(this.searchWidget.searchString)).toList();
        this.scrollableRows = (int)(Math.ceil((float)this.itemsToShow.size() / (float)this.gridColumns) - Math.min((double)this.gridRows, Math.ceil(this.itemsToShow.size()) / (double)this.gridColumns));
        this.scrollRow = class_3532.method_15340((int)this.scrollRow, (int)0, (int)this.scrollableRows);
    }

    public void init() {
        this.gridStartX = this.x + (this.w - this.gridColumns * 18) / 2;
        this.gridStartY = this.y + 2;
        this.border = new BorderScrollRight(this.x(), this.y() - 1, this.w, this.gridRows * 18 + 4, 0, () -> PLCCols.BORDER.col){

            @Override
            public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
                this.renderBorder(context, this.x, this.y, this.w - 1, this.h - 1, (Integer)this.col.get(), 0, false);
                this.renderBorder(context, this.x, this.y, this.w - 1, this.h - 1, PLCCols.TRANSPARENT.col, -1, true);
                GUIUtil.drawVerticalLine1(context, this.x + this.w - 1, this.y + 1, this.y + this.h, PLCCols.TRANSPARENT.col);
            }

            void renderBorder(class_332 context, int x, int y, int dx, int dy, int col, int offset, boolean bottom) {
                GUIUtil.drawHorizontalLine1(context, x - offset, x + dx + offset, y - offset, col);
                GUIUtil.drawVerticalLine1(context, x - offset, y - offset, y + dy + offset, col);
                if (bottom) {
                    GUIUtil.drawHorizontalLine1(context, x - offset, x + dx + offset, y + dy + offset, col);
                }
                GUIUtil.drawVerticalLine1(context, x + dx + offset, y - offset, y + 2, col);
                GUIUtil.drawVerticalLine1(context, x + dx + offset, y - offset + dy - 2, y + offset + dy, col);
            }
        };
        this.searchWidget.setPos(this.x, this.y + this.gridRows * 18 + 2);
    }

    public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
        class_1799 hoveredItem;
        this.border.render(matrices, mouseX, mouseY, delta, (float)this.scrollRow / (float)this.scrollableRows);
        this.searchWidget.method_25394(matrices, mouseX, mouseY, delta);
        for (int m = 0; m < this.itemsToShow.size(); ++m) {
            matrices.method_51448().method_22903();
            int i = m % this.gridColumns;
            int j = m / this.gridColumns;
            if (j >= this.gridRows) break;
            int x = this.gridStartX + i * 18;
            int y = this.gridStartY + j * 18;
            this.drawSlot(x, y, matrices, this.getGridItem(i, j));
            matrices.method_51448().method_22909();
        }
        if ((hoveredItem = this.getHoveredItem(mouseX, mouseY)) != null) {
            matrices.method_51446(this.textRenderer, hoveredItem, mouseX, mouseY);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.scrollRow = (int)Math.min((double)this.scrollableRows, Math.max((double)this.scrollRow - amount, 0.0));
        return ClickableWidget.super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_1799 stack = this.getHoveredItem(mouseX, mouseY);
        if (stack != null && !stack.method_7960()) {
            long amount = Math.min(class_437.method_25442() ? 1 : stack.method_7947(), stack.method_7914());
            ResourceAmount requested = new ResourceAmount((Object)ItemVariant.of((class_1799)stack), amount);
            ClientPlayNetworking.send((class_2960)SyncRequesterScreenS2CPacket.REQUEST_ID, (class_2540)SyncRequesterScreenS2CPacket.encodeRequest(PacketByteBufs.create(), (ResourceAmount<ItemVariant>)requested));
            this.updateSearch();
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchMode) {
            this.searchWidget.write(chr, modifiers);
            return true;
        }
        if (chr == '/') {
            this.searchMode = true;
            return true;
        }
        return ClickableWidget.super.method_25400(chr, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.searchMode) {
            this.searchMode = false;
            this.searchWidget.searchString.setLength(0);
            this.updateSearch();
            return true;
        }
        if (this.searchMode) {
            if (keyCode == 259) {
                this.searchWidget.erase(-1);
            }
            return true;
        }
        return false;
    }

    protected class_1799 getHoveredItem(double mouseX, double mouseY) {
        double x = mouseX - (double)this.gridStartX;
        double y = mouseY - (double)this.gridStartY;
        if (x < 0.0 || y < 0.0) {
            return null;
        }
        int i = (int)(x / 18.0);
        int j = (int)(y / 18.0);
        return this.getGridItem(i, j);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.mouseInGrid(mouseX, mouseY);
    }

    public boolean method_25370() {
        return true;
    }

    public void method_25365(boolean focused) {
    }

    protected class_1799 getGridItem(int i, int j) {
        if (!this.isInGrid(i, j)) {
            return null;
        }
        int m = this.scrollRow * this.gridColumns + i + this.gridColumns * j;
        if (m < 0 || m >= this.itemsToShow.size()) {
            return null;
        }
        return this.itemsToShow.get(m);
    }

    protected boolean mouseInGrid(double mouseX, double mouseY) {
        return mouseX - (double)this.x() < (double)this.w && mouseY - (double)this.y() < (double)this.h;
    }

    protected boolean isInGrid(int i, int j) {
        return i < this.gridColumns && j < this.gridRows;
    }

    public void drawSlot(int x, int y, class_332 matrices, class_1799 itemStack) {
        if (itemStack == null) {
            return;
        }
        matrices.method_51448().method_22903();
        matrices.method_51448().method_46416((float)x, (float)y, 0.0f);
        matrices.method_51428(itemStack, 0, 0, 100);
        matrices.method_51431(this.textRenderer, itemStack, 0, 0);
        matrices.method_51448().method_22909();
    }

    @Override
    public void setDims(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.init();
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public int h() {
        return this.h;
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    public class SearchWidget
    implements class_4068,
    Rectangle,
    Point.Mutable {
        private final class_2561 searchMessage = NeepMeat.translationKey("screen", "guide.search");
        private final StringBuilder searchString = new StringBuilder();
        private int x;
        private int y;

        protected void write(char chr, int modifiers) {
            this.searchString.append(Character.toLowerCase(chr));
            ItemPane.this.updateSearch();
        }

        protected void erase(int dist) {
            if (this.searchString.isEmpty()) {
                return;
            }
            this.searchString.delete(this.searchString.length() - 1, this.searchString.length());
            ItemPane.this.updateSearch();
        }

        @Override
        public int x() {
            return this.x;
        }

        @Override
        public int y() {
            return this.y;
        }

        @Override
        public int w() {
            return ItemPane.this.w;
        }

        @Override
        public int h() {
            Objects.requireNonNull(ItemPane.this.textRenderer);
            return 9;
        }

        public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
            GUIUtil.drawVerticalLine1(matrices, this.x(), this.y() - 1, this.y() + this.h() + 3, PLCCols.BORDER.col);
            GUIUtil.drawVerticalLine1(matrices, this.x() + 1, this.y() - 1, this.y() + this.h() + 2, PLCCols.TRANSPARENT.col);
            GUIUtil.drawVerticalLine1(matrices, this.x() + this.w() - 1, this.y() - 1, this.y() + this.h() + 3, PLCCols.BORDER.col);
            GUIUtil.drawVerticalLine1(matrices, this.x() + this.w() - 2, this.y() - 1, this.y() + this.h() + 2, PLCCols.TRANSPARENT.col);
            GUIUtil.drawHorizontalLine1(matrices, this.x(), this.x() + this.w() - 1, this.y() + this.h() + 1, PLCCols.TRANSPARENT.col);
            GUIUtil.drawHorizontalLine1(matrices, this.x(), this.x() + this.w() - 1, this.y() + this.h() + 2, PLCCols.BORDER.col);
            if (!ItemPane.this.searchMode) {
                GUIUtil.drawText(matrices, ItemPane.this.textRenderer, this.searchMessage, (float)(this.x() + 2), (float)this.y() + (float)(this.h() - 7) / 2.0f, PLCCols.TEXT.col, false);
            } else {
                GUIUtil.drawText(matrices, ItemPane.this.textRenderer, "/" + String.valueOf(this.searchString), (float)(this.x() + 2), (float)this.y() + (float)(this.h() - 7) / 2.0f, PLCCols.TEXT.col, false);
            }
        }

        @Override
        public void setPos(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

