/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.fluid_network;

import com.neep.neepmeat.transport.api.FluidTransportConstants;
import com.neep.neepmeat.transport.fluid_network.FluidPipeVertex;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_3218;

public abstract class SimpleFluidPipeVertex
extends SnapshotParticipant<ResourceAmount<FluidVariant>>
implements FluidPipeVertex {
    private final FluidPipeVertex[] adjacentVertices = new FluidPipeVertex[6];
    protected float pumpHeight = 0.0f;
    protected float height;
    protected long amount;
    protected long oldAmount;
    protected final long pos;
    protected FluidVariant variant = FluidVariant.blank();

    public SimpleFluidPipeVertex(long pos) {
        this.pos = pos;
    }

    public long getCapacity() {
        return FluidTransportConstants.INSTANCE.maxTransfer();
    }

    public long getAmount() {
        return this.amount;
    }

    public FluidVariant getVariant() {
        return this.variant;
    }

    protected ResourceAmount<FluidVariant> createSnapshot() {
        return new ResourceAmount((Object)this.variant, this.amount);
    }

    protected void readSnapshot(ResourceAmount<FluidVariant> snapshot) {
        this.variant = (FluidVariant)snapshot.resource();
        this.amount = snapshot.amount();
    }

    @Override
    public void tick() {
    }

    @Override
    public void preTick() {
        FluidPipeVertex.super.preTick();
        this.oldAmount = this.amount;
    }

    @Override
    public long insert(int fromDir, int toDir, long maxAmount, class_3218 world, FluidVariant insertVariant, TransactionContext transaction) {
        long remaining = this.getCapacity() - this.amount;
        if (!insertVariant.isBlank() && (this.variant.isBlank() || insertVariant.equals(this.variant)) && remaining > 0L) {
            this.updateSnapshots(transaction);
            long permittedAmount = Math.min(this.canInsert(world, toDir, insertVariant, maxAmount), remaining);
            if (permittedAmount > 0L) {
                this.amount += permittedAmount;
                this.variant = insertVariant;
                return permittedAmount;
            }
            return 0L;
        }
        return 0L;
    }

    @Override
    public int getConnectionDir(FluidPipeVertex from) {
        for (int i = 0; i < this.adjacentVertices.length; ++i) {
            if (!from.equals(this.adjacentVertices[i])) continue;
            return i;
        }
        return 0;
    }

    public String toString() {
        StringBuilder adj = new StringBuilder();
        for (FluidPipeVertex v : this.adjacentVertices) {
            if (v == null) continue;
            adj.append(System.identityHashCode(v)).append(", ");
        }
        return "Vertex@" + System.identityHashCode(this) + "{connection=" + String.valueOf(adj) + "head:" + this.getTotalHeight() + "}";
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public FluidPipeVertex getAdjacent(int dir) {
        return this.adjacentVertices[dir];
    }

    @Override
    public FluidPipeVertex[] getAdjVertices() {
        return this.adjacentVertices;
    }

    @Override
    public void setHeight(float value) {
        this.height = value;
    }

    @Override
    public long getPos() {
        return this.pos;
    }

    @Override
    public float getTotalHeight() {
        return this.pumpHeight + this.getHeight();
    }

    protected float getHeight() {
        return FluidTransportConstants.INSTANCE.pipeGravityEnabled() ? this.height : 0.0f;
    }

    protected int numEdges() {
        int edges = 0;
        for (FluidPipeVertex pipeNetVertex : this.getAdjVertices()) {
            if (pipeNetVertex == null) continue;
            ++edges;
        }
        return edges;
    }

    @Override
    public boolean canSimplify() {
        return this.numEdges() <= 2;
    }

    @Override
    public void reset() {
        this.pumpHeight = 0.0f;
        this.clearEdges();
    }

    protected void clearEdges() {
        for (int i = 0; i < 6; ++i) {
            FluidPipeVertex adj = this.getAdjacent(i);
            if (adj == null) continue;
            for (int j = 0; j < 6; ++j) {
                if (adj.getAdjVertex(j) != this) continue;
                adj.setAdjVertex(j, null);
            }
            this.setAdjVertex(i, null);
        }
    }

    public long canInsert(class_3218 world, int inDir, FluidVariant variant, long maxAmount) {
        return Math.max(0L, Math.min(maxAmount, this.getCapacity() - this.getAmount()));
    }
}

