/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.item_network;

import com.neep.meatlib.util.graph.ConnectablePipe;
import com.neep.meatlib.util.graph.PipeGraphUtil;
import com.neep.meatlib.util.graph.PipeVertex;
import com.neep.neepmeat.api.storage.WorldSupplier;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.api.pipe.PipeConnections;
import com.neep.neepmeat.transport.item_network.ItemPipeGraphHelper;
import com.neep.neepmeat.transport.item_network.ItemPipeVertex;
import it.unimi.dsi.fastutil.Pair;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public abstract class ItemPipeGraphHelperImpl
implements ItemPipeGraphHelper,
ItemPipeVertex {
    private final ItemPipeVertex vertex = this;
    protected final WorldSupplier world;
    protected class_2680 cachedState1;
    protected final ConnectablePipe pipe;
    private final class_2338 pos;
    protected PipeConnections connections = new PipeConnections();

    protected ItemPipeGraphHelperImpl(WorldSupplier world, Supplier<class_2680> getCachedState, ConnectablePipe pipe, class_2338 pos) {
        this.world = world;
        this.cachedState1 = getCachedState.get();
        this.connections = pipe.getConnections(this.cachedState1);
        this.pipe = pipe;
        this.pos = pos;
    }

    @Override
    public void prepareForRemoval(class_2680 state, class_2680 newState) {
        this.vertex.clearEdges();
        PipeGraphUtil.eraseHiddenFromNeighbours(this.world.get(), this.pos, state, this.pipe, ItemPipe::findItemPipe);
    }

    @Override
    public void updateConnectionChange(class_2680 state, class_2680 newState) {
        this.setCachedState(newState);
        int connections = this.pipe.countConnections(newState);
        if (this.vertex.canSimplify() && connections == 1) {
            this.vertex.clearEdges();
            for (class_2350 direction : this.pipe.getConnections(this.getCachedState()).directions()) {
                Pair<ItemPipeVertex, class_2350> adjacent = this.findNextVertex(this.pos, direction);
                if (adjacent == null) continue;
                ((ItemPipeVertex)adjacent.first()).setAdjVertex(((class_2350)adjacent.second()).ordinal(), null);
                PipeGraphUtil.jankParticles(this.world.get(), (PipeVertex)adjacent.first(), false);
                this.setAdjVertex(direction.ordinal(), null);
            }
        } else {
            this.updateHiddenConnections(newState);
        }
    }

    @Override
    public void updateHiddenConnections(class_2680 newState) {
        this.setCachedState(newState);
        this.vertex.clearEdges();
        int connections = this.pipe.countConnections(newState);
        if (connections > 2 || !this.vertex.canSimplify()) {
            this.findAdjacent();
        } else if (connections == 2) {
            PipeGraphUtil.linkVertices(this.world.get(), this.pos, this.getCachedState(), this.pipe, ItemPipeVertex::find, ItemPipe::findItemPipe);
        }
    }

    private void findAdjacent() {
        for (class_2350 direction : this.pipe.getConnections(this.getCachedState()).directions()) {
            Pair<ItemPipeVertex, class_2350> adjacent = this.findNextVertex(this.pos, direction);
            if (adjacent == null) continue;
            this.vertex.setAdjVertex(direction.method_10146(), (ItemPipeVertex)adjacent.first());
            ((ItemPipeVertex)adjacent.first()).setAdjVertex(((class_2350)adjacent.second()).method_10146(), this.vertex);
            PipeGraphUtil.jankParticles(this.world.get(), (PipeVertex)adjacent.first(), true);
        }
    }

    private Pair<ItemPipeVertex, class_2350> findNextVertex(class_2338 pos, class_2350 out) {
        return PipeGraphUtil.findNextVertex(this.world.get(), pos, out, ItemPipeVertex::find, ItemPipe::findItemPipe);
    }

    @Override
    public class_2338 getPos() {
        return this.pos;
    }

    public class_2680 getCachedState() {
        return this.cachedState1;
    }

    public void setCachedState(class_2680 state) {
        this.cachedState1 = state;
        this.connections = this.pipe.getConnections(this.cachedState1);
    }
}

