/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.screen;

import com.neep.meatlib.inventory.ImplementedInventory;
import com.neep.neepmeat.screen_handler.BasicScreenHandler;
import com.neep.neepmeat.transport.api.item_network.RoutingNetwork;
import com.neep.neepmeat.transport.network.SyncRequesterScreenS2CPacket;
import com.neep.neepmeat.transport.screen.TransportScreenHandlers;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_3919;

public class ItemRequesterScreenHandler
extends BasicScreenHandler {
    public static final int PROPERTIES = 1;
    protected RoutingNetwork routingNetwork;
    protected class_2338 pos;
    protected final class_1657 player;
    protected final List<ResourceAmount<ItemVariant>> items = new ArrayList<ResourceAmount<ItemVariant>>(20);

    public ItemRequesterScreenHandler(int syncId, class_1661 playerInventory, class_2540 buf) {
        this(syncId, playerInventory, ImplementedInventory.ofSize(63), RoutingNetwork.DEFAULT, new class_2338(0, 0, 0), playerInventory.field_7546, (class_3913)new class_3919(1));
        this.receivePacket(buf);
    }

    public ItemRequesterScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory, RoutingNetwork network, class_2338 pos, class_1657 player, class_3913 delegate) {
        super((class_3917<?>)TransportScreenHandlers.ITEM_REQUESTER_HANDLER, playerInventory, inventory, syncId, delegate);
        this.routingNetwork = network;
        this.pos = pos;
        this.player = player;
        ItemRequesterScreenHandler.method_17359((class_1263)inventory, (int)1);
        this.createPlayerSlots(8, 149, playerInventory);
    }

    protected void createSlots() {
        int w_slot = 18;
        int h_slot = 18;
        for (int j = 0; j < 7; ++j) {
            for (int i = 0; i < 9; ++i) {
                this.method_7621(new class_1735(this.inventory, i + j * 9, 8 + i * w_slot, 8 + j * h_slot));
            }
        }
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        super.method_7593(slotIndex, button, actionType, player);
    }

    public void method_34252() {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            class_2540 buf = ItemRequesterScreenHandler.syncToPacket(PacketByteBufs.create(), this.items, this.routingNetwork);
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)SyncRequesterScreenS2CPacket.SYNC_ID, (class_2540)buf);
        }
        super.method_34252();
    }

    public static class_2540 syncToPacket(class_2540 buf, List<ResourceAmount<ItemVariant>> items, RoutingNetwork network) {
        try (Transaction transaction = Transaction.openOuter();){
            items.clear();
            List<ResourceAmount<ItemVariant>> available = network.getAllAvailable((TransactionContext)transaction);
            items.addAll(available);
            transaction.commit();
        }
        ItemRequesterScreenHandler.sortItems(items, 0);
        return SyncRequesterScreenS2CPacket.encodeSync(buf, items);
    }

    protected static void sortItems(List<ResourceAmount<ItemVariant>> items, int type) {
        items.sort((s1, s2) -> ((ItemVariant)s1.resource()).toStack().method_7960() ? 1 : ((ItemVariant)s1.resource()).toStack().method_7964().method_10858(256).compareTo(((ItemVariant)s2.resource()).toStack().method_7964().method_10858(256)));
    }

    public static boolean isInGrid(int index) {
        return index >= 36 && index < 99;
    }

    public void receivePacket(class_2540 buf) {
        SyncRequesterScreenS2CPacket.decodeSync(buf, this.items);
    }

    public List<ResourceAmount<ItemVariant>> getItems() {
        return this.items;
    }

    public void receiveRequestPacket(class_2540 buf) {
        ResourceAmount<ItemVariant> ra = SyncRequesterScreenS2CPacket.decodeRequest(buf);
        try (Transaction transaction = Transaction.openOuter();){
            if (this.routingNetwork.request(ra, this.pos, class_2350.field_11036, RoutingNetwork.RequestType.ANY_AMOUNT, (TransactionContext)transaction)) {
                transaction.commit();
            }
        }
        this.method_34252();
    }
}

