/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.worm;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.neep.neepmeat.entity.skyworm.SkywormAnimationTimes;
import com.neep.neepmeat.machine.live_machine.block.entity.DistributorPoint;
import com.neep.neepmeat.machine.live_machine.block.entity.DistributorPointBlockEntity;
import com.neep.neepmeat.transport.worm.DistributorDestination;
import com.neep.neepmeat.transport.worm.DistributorParcel;
import com.neep.neepmeat.transport.worm.DistributorRoutingComponent;
import com.neep.neepmeat.transport.worm.GlobalDistributorRouting;
import com.neep.neepmeat.transport.worm.PointHandle;
import com.neep.neepmeat.transport.worm.RouteLock;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class DistributorRouting
implements DistributorRoutingComponent,
ServerTickingComponent {
    private final class_1937 world;
    private final Map<class_2338, PointHandle> handles = new HashMap<class_2338, PointHandle>();
    private final List<RouteInProgress> inProgress = new ObjectArrayList();
    private final Set<class_2338> blocked = new HashSet<class_2338>();

    public DistributorRouting(class_1937 world) {
        GlobalDistributorRouting global;
        this.world = world;
        if (!world.method_8608() && (global = GlobalDistributorRouting.getInstance()) != null) {
            global.registerComponent(this);
        }
    }

    @Override
    public void registerPoint(DistributorPoint point) {
        this.handles.put(point.getPointPos(), new PointHandle(point.getPointPos(), point.getAddress(), point.getMode(), point.isPowered()));
    }

    @Override
    public void unregisterPoint(class_2338 pos) {
        this.handles.remove(pos);
        this.blocked.remove(pos);
        this.inProgress.removeIf(p -> p.destination.equals((Object)pos));
    }

    @Override
    public void send(DistributorParcel parcel, DistributorDestination destination, SkywormAnimationTimes times) {
        this.inProgress.add(new RouteInProgress(parcel, destination.pos(), this.world.method_8510(), times));
        this.blocked.add(destination.pos());
    }

    @Override
    public RouteLock acquireRoute(class_2338 pos) {
        this.blocked.add(pos);
        return new RouteLock(this.world, pos);
    }

    @Override
    public void releaseRoute(class_2338 pos) {
        this.blocked.remove(pos);
        this.inProgress.removeIf(p -> p.destination.equals((Object)pos));
    }

    @Override
    public void collectMatching(List<DistributorDestination> result, String address) {
        for (PointHandle handle : this.handles.values()) {
            if (!handle.mode().canReceive() || !handle.powered() || !handle.matches(address) || this.blocked.contains(handle.pos())) continue;
            result.add(new DistributorDestination(this.world, handle.pos()));
        }
    }

    @Override
    public class_1937 getWorld() {
        return this.world;
    }

    public void readFromNbt(class_2487 tag) {
        class_2499 list = tag.method_10554("handles", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 compound = list.method_10602(i);
            class_2338 pos = class_2338.method_10092((long)compound.method_10537("pos"));
            this.handles.put(pos, PointHandle.fromNbt(compound.method_10562("handle")));
        }
        this.inProgress.clear();
        this.blocked.clear();
        this.inProgress.addAll(DistributorParcel.readList(tag.method_10554("in_progress", 10), RouteInProgress::fromNbt));
        this.inProgress.forEach(p -> this.blocked.add(p.destination));
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        class_2499 list = new class_2499();
        for (Map.Entry<class_2338, PointHandle> entry : this.handles.entrySet()) {
            class_2487 compound = new class_2487();
            compound.method_10544("pos", entry.getKey().method_10063());
            compound.method_10566("handle", entry.getValue().toNbt());
            list.add((Object)compound);
        }
        tag.method_10566("handles", (class_2520)list);
        tag.method_10566("in_progress", (class_2520)DistributorParcel.writeList(this.inProgress, RouteInProgress::toNbt));
    }

    public void serverTick() {
        Iterator<RouteInProgress> it = this.inProgress.iterator();
        while (it.hasNext()) {
            RouteInProgress entry = it.next();
            if (this.world.method_8510() >= entry.startTime + entry.times.total()) {
                DistributorPoint be = new DistributorDestination(this.world, entry.destination).getDistributorPoint();
                if (be == null) continue;
                be.receive(entry.parcel);
                this.blocked.remove(entry.destination);
                it.remove();
                continue;
            }
            if (this.world.method_8510() != entry.startTime + entry.times.receiverWormAppear()) continue;
            class_2338 pos = entry.destination;
            int x = pos.method_10263();
            int y = pos.method_10264();
            int z = pos.method_10260();
            if (!this.world.method_33598(x, z) || !this.world.method_18458((double)x, (double)y, (double)z, 60.0)) continue;
            DistributorPointBlockEntity.createWorm(this.getWorld(), this.world.method_8320(pos), pos, entry.times);
        }
    }

    record RouteInProgress(DistributorParcel parcel, class_2338 destination, long startTime, SkywormAnimationTimes times) {
        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10566("parcel", (class_2520)this.parcel.toNbt());
            nbt.method_10544("destination", this.destination.method_10063());
            nbt.method_10544("start_time", this.startTime);
            nbt.method_10566("times", (class_2520)SkywormAnimationTimes.CODEC.encode((Object)this.times, (DynamicOps)class_2509.field_11560, (Object)new class_2487()).result().get());
            return nbt;
        }

        public static RouteInProgress fromNbt(class_2487 nbt) {
            return new RouteInProgress(DistributorParcel.fromNbt(nbt.method_10562("parcel")), class_2338.method_10092((long)nbt.method_10537("destination")), nbt.method_10537("start_time"), (SkywormAnimationTimes)((Pair)SkywormAnimationTimes.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("times")).getOrThrow(true, s -> {})).getFirst());
        }
    }
}

