/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class IndexedHashMap<K, V>
implements Cloneable {
    protected HashMap<K, V> map = new HashMap();
    protected ArrayList<V> values;
    protected ArrayList<K> keys = new ArrayList();

    public IndexedHashMap() {
        this.values = new ArrayList();
    }

    public V put(K k, V v) {
        if (this.map.get(k) == null && !this.keys.contains(k)) {
            this.values.add(v);
            this.keys.add(k);
            int index = this.values.indexOf(v);
            this.map.put(k, v);
            return v;
        }
        return null;
    }

    public void remove(K k) {
        int index = this.keys.indexOf(k);
        this.keys.remove(index);
        this.values.remove(index);
        this.map.remove(k);
    }

    public int size() {
        return this.values.size();
    }

    public void clear() {
        this.keys.clear();
        this.values.clear();
        this.map.clear();
    }

    public List<K> keySet() {
        return this.keys;
    }

    public V get(int i) {
        return this.values.get(i);
    }

    public V get(K k) {
        return this.map.get(k);
    }

    public K getKey(int i) {
        return this.keys.get(i);
    }

    public int getIndex(K k) {
        return this.keys.indexOf(k);
    }

    public void forEach(Consumer<? super V> action) {
        Objects.requireNonNull(action);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(this.get((K)i));
        }
    }

    public IndexedHashMap<K, V> clone() {
        try {
            IndexedHashMap clone = (IndexedHashMap)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return this.keys.toString() + "\n" + this.values.toString() + "\n" + this.map.toString();
    }
}

