/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.util;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.concurrent.ThreadLocalRandom;

public class IterateRandomly
implements IntIterable {
    private static final int MAX_COUNT = 100000;
    private final int maxrange;
    private final int prime;
    private int index;
    private int runningvalue;

    public IterateRandomly(int range) {
        if (range < 2) {
            throw new IllegalArgumentException("Your range needs to be greater than 1 " + range);
        }
        int min = range / 2;
        this.maxrange = range;
        this.prime = IterateRandomly.selectCoPrimeResev(min, range);
        int offset = ThreadLocalRandom.current().nextInt(range);
        this.index = 0;
        this.runningvalue = offset;
    }

    static int selectCoPrimeResev(int min, int target) {
        int count = 0;
        int selected = 0;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int val = min; val < target; ++val) {
            if (IterateRandomly.coprime(val, target) && (++count == 1 || rand.nextInt(count) < 1)) {
                selected = val;
            }
            if (count != 100000) continue;
            return val;
        }
        return selected;
    }

    static boolean coprime(int u, int v) {
        return IterateRandomly.greatestCoprime(u, v) == 1;
    }

    static int greatestCoprime(int u, int v) {
        if (u == 0) {
            return v;
        }
        if (v == 0) {
            return u;
        }
        int shift = 0;
        while (((u | v) & 1) == 0) {
            u >>= 1;
            v >>= 1;
            ++shift;
        }
        while ((u & 1) == 0) {
            u >>= 1;
        }
        while (true) {
            if ((v & 1) == 0) {
                v >>= 1;
                continue;
            }
            if (u > v) {
                int t = v;
                v = u;
                u = t;
            }
            if ((v -= u) == 0) break;
        }
        return u << shift;
    }

    public boolean hasNext() {
        return this.index < this.maxrange;
    }

    public int next() {
        this.runningvalue += this.prime;
        if (this.runningvalue >= this.maxrange) {
            this.runningvalue -= this.maxrange;
        }
        ++this.index;
        return this.runningvalue;
    }

    public IntIterator iterator() {
        return new Iterator();
    }

    private class Iterator
    implements IntIterator {
        private Iterator() {
        }

        public int nextInt() {
            return IterateRandomly.this.next();
        }

        public boolean hasNext() {
            return IterateRandomly.this.hasNext();
        }
    }
}

