/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.util;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.apache.commons.lang3.NotImplementedException;

public class MeatLibCodecs {
    public static final Codec<class_1792> CHECKED_ITEM = class_2960.field_25139.comapFlatMap(MeatLibCodecs.checkDefault(new class_2960("air"), class_1802.field_8162, class_7923.field_41178), arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0));
    public static final Codec<class_3611> CHECKED_FLUID = class_2960.field_25139.comapFlatMap(MeatLibCodecs.checkDefault(new class_2960("empty"), class_3612.field_15906, class_7923.field_41173), arg_0 -> ((class_7922)class_7923.field_41173).method_10221(arg_0));

    public static <T> Function<class_2960, DataResult<T>> checkDefault(class_2960 defaultId, T defaultValue, class_2378<T> registry) {
        return id -> {
            Object entry = registry.method_10223(id);
            if (entry == defaultValue && !id.equals((Object)defaultId)) {
                return DataResult.error(() -> "id " + String.valueOf(id) + " not found in registry " + String.valueOf(registry.method_30517().method_29177()));
            }
            return DataResult.success((Object)entry);
        };
    }

    public static <T, R> R notImplemented(T t) {
        throw new NotImplementedException("My life is too short for this");
    }

    public static <T, O> RecordCodecBuilder<O, T> decodeOnly(MapCodec<T> mapCodec) {
        return mapCodec.forGetter(MeatLibCodecs::notImplemented);
    }

    public static <T> T collapseEither(Either<? extends T, ? extends T> either) {
        return either.left().isPresent() ? either.left().get() : either.right().orElseThrow();
    }

    public static <T> Function<? super Either<? extends T, ? extends T>, ? extends DataResult<? extends T>> collapseEither(String error) {
        return e -> {
            if (e.left().isPresent()) {
                return DataResult.success(e.left().get());
            }
            if (e.right().isPresent()) {
                return DataResult.success(e.right().get());
            }
            return DataResult.error(() -> error);
        };
    }

    public static class JankDispatch<T, S>
    extends MapCodec<T> {
        private final String typeKey;
        private final Codec<S> codec;
        private final Function<S, Codec<T>> extractCodec;

        public JankDispatch(String typeKey, Codec<S> keyCodec, Function<S, Codec<T>> extractCodec) {
            this.typeKey = typeKey;
            this.codec = keyCodec;
            this.extractCodec = extractCodec;
        }

        public <T1> DataResult<T> decode(DynamicOps<T1> ops, MapLike<T1> input) {
            Object elementName = input.get(this.typeKey);
            if (elementName == null) {
                return DataResult.error(() -> "Input does not contain a key [" + this.typeKey + "]: " + String.valueOf(input));
            }
            return this.codec.decode(ops, elementName).flatMap(type -> {
                DataResult elementDecoder = DataResult.success(this.extractCodec.apply(type.getFirst()));
                return elementDecoder.flatMap(c -> c.decode(ops, ops.createMap(input.entries())).map(Pair::getFirst));
            });
        }

        public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
            return Stream.of(this.typeKey).map(arg_0 -> ops.createString(arg_0));
        }

        public <T1> RecordBuilder<T1> encode(T input, DynamicOps<T1> ops, RecordBuilder<T1> prefix) {
            return prefix.withErrorsFrom(DataResult.error(() -> "JankDispatch::encode not implemented"));
        }
    }
}

