/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.item;

import com.neep.meatlib.item.MeatlibItemSettings;
import com.neep.meatweapons.MWItems;
import com.neep.meatweapons.Util;
import com.neep.meatweapons.client.model.FusionCannonItemModel;
import com.neep.meatweapons.entity.ExplodingShellEntity;
import com.neep.meatweapons.entity.FusionBlastEntity;
import com.neep.meatweapons.entity.WeaponCooldownAttachment;
import com.neep.meatweapons.item.Aimable;
import com.neep.meatweapons.item.BaseGunItem;
import com.neep.meatweapons.item.GunItem;
import com.neep.meatweapons.item.WeakTwoHanded;
import com.neep.meatweapons.network.MWAttackC2SPacket;
import com.neep.meatweapons.particle.MWGraphicsEffects;
import com.neep.neepmeat.init.NMSounds;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import org.joml.Vector3f;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.model.GeoModel;

public class FusionCannonItem
extends BaseGunItem
implements WeakTwoHanded,
Aimable {
    protected static final String KEY_CHARGE = "charge";
    public static final int MAX_CHARGE_TIME = 60;
    public static final int MIN_CHARGE_TIME = 13;
    public static final int EXPLOSION_TIME = 150;

    public FusionCannonItem() {
        super(MWItems.SMALL_BALLISTIC_MAGAZINE, 16, 10, false, new MeatlibItemSettings());
        this.sounds.put(GunItem.GunSounds.FIRE_PRIMARY, NMSounds.FUSION_FIRE);
        this.sounds.put(GunItem.GunSounds.RELOAD, NMSounds.RELOAD);
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public int method_7881(class_1799 stack) {
        return 70000;
    }

    @Override
    public void trigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        WeaponCooldownAttachment manager = WeaponCooldownAttachment.get(player);
        if (id == 1) {
            if (!manager.isCoolingDown(stack, 0) && stack.method_7919() != this.maxShots) {
                manager.set(stack, 0, this.cooldown);
                this.fireBeam(world, (class_1309)player, stack, pitch, yaw);
                if (!player.method_7337()) {
                    stack.method_7974(stack.method_7919() + 1);
                }
            }
        } else if (id == 2) {
            if (stack.method_7919() + 2 > stack.method_7936()) {
                this.reload(player, stack, null);
                return;
            }
            class_2487 nbt = stack.method_7911(KEY_CHARGE);
            nbt.method_10569(KEY_CHARGE, 0);
            nbt.method_10556("charging", true);
            world.method_43129(null, (class_1297)player, NMSounds.FUSION_BLAST_CHARGE, class_3419.field_15248, 1.0f, 1.0f);
        }
        if (!manager.isCoolingDown(stack, 0) && stack.method_7919() >= this.maxShots) {
            this.reload(player, stack, null);
        }
    }

    @Override
    public void triggerClient(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType) {
        WeaponCooldownAttachment manager = WeaponCooldownAttachment.get(player);
        if (id != 1 || manager.isCoolingDown(stack, 0) || stack.method_7919() != this.maxShots) {
            // empty if block
        }
    }

    @Override
    public void tickTrigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        class_2487 nbt;
        if (id == 1) {
            this.trigger(world, player, stack, id, pitch, yaw, handType, hand);
        }
        if (id == 2 && (nbt = stack.method_7911(KEY_CHARGE)).method_10577("charging")) {
            int charge = nbt.method_10550(KEY_CHARGE);
            nbt.method_10569(KEY_CHARGE, charge + 1);
            if (charge != 0 && charge % 20 == 0) {
                world.method_43129(null, (class_1297)player, NMSounds.MARATHON_BEEP, class_3419.field_15248, 1.0f, 1.0f + (float)charge / 150.0f);
            }
            if (charge > 150) {
                world.method_8454((class_1297)player, null, ExplodingShellEntity.KEEP_BEHAVIOUR, player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, false, class_1937.class_7867.field_40890);
                world.method_43129(null, (class_1297)player, NMSounds.FUSION_BLAST_FIRE, class_3419.field_15248, 1.0f, 1.0f);
                nbt.method_10569(KEY_CHARGE, 0);
                nbt.method_10556("charging", false);
            }
        }
    }

    @Override
    public void release(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        WeaponCooldownAttachment manager = WeaponCooldownAttachment.get(player);
        if (id == 2) {
            if (stack.method_7919() + 2 <= this.maxShots && FusionCannonItem.canFireBlast(stack)) {
                class_2487 nbt = stack.method_7911(KEY_CHARGE);
                int charge = nbt.method_10550(KEY_CHARGE);
                float power = charge;
                this.fireShell(world, player, stack, 2.0, (world1, x, y, z, vx, vy, vz) -> new FusionBlastEntity(world1, x, y, z, vx, vy, vz, power));
                if (!player.method_7337()) {
                    stack.method_7974(stack.method_7919() + 2);
                }
                world.method_43129(null, (class_1297)player, NMSounds.FUSION_BLAST_FIRE, class_3419.field_15248, 1.0f, 1.0f);
                nbt.method_10556("charging", false);
            } else {
                world.method_43129(null, (class_1297)player, NMSounds.CLICK, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    @Override
    protected void fireShell(class_1937 world, class_1657 player, class_1799 stack, double speed, BaseGunItem.ProjectileFactory factory) {
        class_243 vec = class_243.method_1030((float)player.method_36455(), (float)player.method_5791()).method_1021(speed);
        class_243 pos = new class_243(player.method_23317(), player.method_23318() + 1.4, player.method_23321());
        class_1665 shell = factory.create(world, pos.field_1352, pos.field_1351, pos.field_1350, vec.field_1352, vec.field_1351, vec.field_1350);
        shell.method_7432((class_1297)player);
        world.method_8649((class_1297)shell);
        this.playSound(world, (class_1309)player, GunItem.GunSounds.FIRE_SECONDARY);
        this.syncAnimation(world, (class_1309)player, stack, "fire", true);
    }

    @Override
    protected GeoModel<? extends BaseGunItem> createModel() {
        return new FusionCannonItemModel();
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
    }

    protected static boolean canFireBlast(class_1799 stack) {
        return stack.method_7911(KEY_CHARGE).method_10550(KEY_CHARGE) > 13;
    }

    @Override
    public Vector3f getAimOffset() {
        return new Vector3f(0.56f, 0.0f, 0.0f);
    }

    @Override
    public class_243 getMuzzleOffset(class_1309 player, class_1799 stack) {
        boolean sneak = player.method_5715();
        return new class_243(sneak ? 0.0 : (player.method_6047().equals(stack) == (player.method_6068() == class_1306.field_6183) ? -0.2 : 0.2), sneak ? -0.25 : 0.1, 0.5);
    }

    public void fireBeam(class_1937 world, class_1309 entity, class_1799 stack, double pitch, double yaw) {
        class_1282 class_12822;
        class_243 pos = new class_243(entity.method_23317(), entity.method_23320() - 0.2, entity.method_23321());
        class_243 transform = this.getMuzzleOffset(entity, stack).method_1037((float)(-pitch)).method_1024((float)(-yaw));
        pos = pos.method_1019(transform);
        class_243 end = pos.method_1019(Util.getRotationVector((float)pitch, (float)yaw).method_1021(20.0));
        Optional<class_3966> target = FusionCannonItem.hitScan(entity, pos, end, 20.0, this);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_12822 = world.method_48963().method_48802(player);
        } else {
            class_12822 = world.method_48963().method_48812(entity);
        }
        class_1282 damage = class_12822;
        target.ifPresent(livingEntity -> livingEntity.method_17782().method_5643(damage, 4.0f));
        this.playSound(world, entity, GunItem.GunSounds.FIRE_PRIMARY);
        this.syncAnimation(world, entity, stack, "fire", true);
    }

    public void fireBeam(class_1937 world, class_1309 entity, class_1297 target, class_1799 stack) {
        class_1282 class_12822;
        class_243 pos = entity.method_33571();
        class_243 end = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0);
        Optional<class_3966> foundTarget = FusionCannonItem.hitScan(entity, pos, end, 20.0, this);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_12822 = world.method_48963().method_48802(player);
        } else {
            class_12822 = world.method_48963().method_48812(entity);
        }
        class_1282 damage = class_12822;
        foundTarget.ifPresent(livingEntity -> livingEntity.method_17782().method_5643(damage, 4.0f));
        this.playSound(world, entity, GunItem.GunSounds.FIRE_PRIMARY);
        this.syncAnimation(world, entity, stack, "fire", true);
    }

    @Override
    public void syncBeamEffect(class_3218 world, class_243 pos, class_243 end, float width, int maxTime, double showRadius) {
        class_243 col = new class_243(214.0, 175.0, 32.0);
        for (class_3222 player : PlayerLookup.around((class_3218)world, (class_243)pos, (double)showRadius)) {
            MWGraphicsEffects.syncBeamEffect(player, MWGraphicsEffects.BEAM, (class_1937)world, pos, end, col, 0.5f, 5);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::fireController).triggerableAnim("fire", RawAnimation.begin().thenPlay("animation.fusion.fire"))});
    }
}

