/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.meatgun.module;

import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.api.network.ParamCodecs;
import com.neep.meatlib.graphics.GraphicsEffects;
import com.neep.meatlib.network.GlobalChannelManager;
import com.neep.meatlib.network.PacketBufUtil;
import com.neep.meatweapons.item.meatgun.MeatgunModuleItem;
import com.neep.meatweapons.meatgun.AmmunitionType;
import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.meatgun.module.AmmunitionUsingModule;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.MeatgunModules;
import com.neep.meatweapons.network.MWAttackC2SPacket;
import com.neep.meatweapons.network.MeatgunNetwork;
import com.neep.meatweapons.particle.MWGraphicsEffects;
import com.neep.neepmeat.machine.phage_ray.PhageRayEntity;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ShortPhageRayModule
extends AmmunitionUsingModule {
    public static final GlobalChannelManager<SetBreakProgress> BREAK_PROGRESS_S2C = GlobalChannelManager.create(new class_2960("meatweapons", "break_progress"), ChannelFormat.builder(SetBreakProgress.class).param(ParamCodec.BOOLEAN).param(ParamCodecs.BLOCK_POS).param(ParamCodec.FLOAT).build());
    public static final double DISTANCE = 15.0;
    protected final int maxCooldown;
    @Nullable
    protected class_2338 target;
    protected float progress;
    protected int blocksRemaining = 0;
    protected int cooldown = 0;
    protected int counter;
    private boolean triggerHeld;
    protected class_2499 enchantments = new class_2499();
    public float lerpPanelOffset;

    public ShortPhageRayModule(RootModuleHolder.Listener l, class_2487 nbt) {
        this(l);
        this.readNbt(nbt);
    }

    public ShortPhageRayModule(RootModuleHolder.Listener l, class_1799 stack) {
        this(l);
        this.enchantments = stack.method_7921().method_10612();
    }

    protected ShortPhageRayModule(RootModuleHolder.Listener listener) {
        super(listener, AmmunitionType.ENERGY);
        this.maxCooldown = (int)this.getType().attributes().get(MeatgunModule.Attribute.COOLDOWN);
    }

    @Override
    public void tickTrigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        boolean reloaded = false;
        if (this.blocksRemaining <= 0 && this.cooldown == 0 && this.consume((class_1263)player.method_31548(), player)) {
            this.cooldown = 0;
            this.blocksRemaining = 8;
            reloaded = true;
        }
        if (this.blocksRemaining > 0 && (reloaded || this.counter % 30 == 0)) {
            this.syncBeamEffect((class_3222)player, world, class_243.field_1353, class_243.field_1353, class_243.field_1353, 0.2f, 30 - this.counter % 30, hand);
        }
        if (this.blocksRemaining > 0 && this.cooldown == 0) {
            class_3965 blockHit;
            this.cooldown = 1;
            class_239 hit = player.method_5745(15.0, 1.0f, false);
            class_2338 hitPos = null;
            if (hit instanceof class_3965 && !world.method_8320((blockHit = (class_3965)hit).method_17777()).method_26215()) {
                hitPos = blockHit.method_17777();
            }
            if (!Objects.equals(hitPos, this.target)) {
                this.target = hitPos;
                this.progress = 0.0f;
            }
        }
        if (this.blocksRemaining > 0 && this.target != null) {
            float speed;
            class_2680 state;
            float newProgress;
            if (this.progress < 1.0f && (newProgress = this.progress + PhageRayEntity.calcBlockBreakingDelta(state = world.method_8320(this.target), (class_1922)world, this.target, false, speed = 5.0f + 1.1f * (float)class_1890.method_22445((class_2499)this.enchantments).getOrDefault(class_1893.field_9131, 0).intValue() + 1.5f * (float)this.listener.getHolder().moduleCache().modulesOfType(MeatgunModules.PHAGE_RAY_SPEED_MODIFIER).size())) != this.progress) {
                this.progress = newProgress;
                world.method_8517(player.method_5628(), this.target, (int)(this.progress * 10.0f));
                BREAK_PROGRESS_S2C.emitter(player).setBreakProgress(false, this.target, this.progress);
            }
            if (this.progress >= 1.0f) {
                boolean harvest = true;
                boolean retrieve = false;
                if (retrieve) {
                    class_2680 state2 = world.method_8320(this.target);
                    List dropped = class_2248.method_9562((class_2680)state2, (class_3218)((class_3218)world), (class_2338)this.target, (class_2586)world.method_8321(this.target));
                    boolean inserted = this.insertItems(player, dropped);
                    world.method_22352(this.target, !inserted);
                } else {
                    world.method_22352(this.target, harvest);
                }
                this.progress = 0.0f;
                --this.blocksRemaining;
            }
        }
        ++this.counter;
    }

    protected boolean insertItems(class_1657 player, List<class_1799> stacks) {
        try (Transaction transaction = Transaction.openOuter();){
            PlayerInventoryStorage storage = PlayerInventoryStorage.of((class_1657)player);
            for (class_1799 itemStack : stacks) {
                long count = itemStack.method_7947();
                long inserted = storage.insert(ItemVariant.of((class_1799)itemStack), (long)itemStack.method_7947(), (TransactionContext)transaction);
                if (inserted == count) continue;
                transaction.abort();
                boolean bl = false;
                return bl;
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void trigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        this.triggerHeld = true;
        this.listener.markDirty(RootModuleHolder.Reason.SAVE_DATA);
        MeatgunNetwork.SEND_ANIMATION.emitter(player).apply("phage_ray_hold", null);
    }

    @Override
    public void release(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        this.counter = 0;
        BREAK_PROGRESS_S2C.emitter(player).setBreakProgress(true, class_2338.field_10980, -1.0f);
        this.triggerHeld = false;
        this.listener.markDirty(RootModuleHolder.Reason.SAVE_DATA);
    }

    @Override
    public void tick(class_1657 player) {
        this.cooldown = Math.max(0, this.cooldown - 1);
    }

    @Override
    public MeatgunModule.Type<? extends MeatgunModule> getType() {
        return MeatgunModules.SHORT_PHAGE_RAY;
    }

    @Override
    public class_1799 createStack(MeatgunModuleItem item) {
        class_1799 stack = super.createStack(item);
        stack.method_7948().method_10566("Enchantments", (class_2520)this.enchantments);
        return stack;
    }

    private void syncBeamEffect(class_3222 player, class_1937 world, class_243 start, class_243 end, class_243 velocity, float scale, int maxTime, class_1268 hand) {
        if (world.field_9236) {
            throw new IllegalStateException("packet create called on the client!");
        }
        class_2540 byteBuf = GraphicsEffects.createPacket(MWGraphicsEffects.SMALL_PHAGE_RAY, world);
        PacketBufUtil.writeVec3d(byteBuf, start);
        PacketBufUtil.writeVec3d(byteBuf, end);
        PacketBufUtil.writeVec3d(byteBuf, velocity);
        byteBuf.writeFloat(scale);
        byteBuf.writeInt(maxTime);
        byteBuf.writeBoolean(hand == class_1268.field_5810);
        byteBuf.method_10804(player.method_5628());
        byteBuf.method_10797(this.uuid);
        ServerPlayNetworking.send((class_3222)player, (class_2960)GraphicsEffects.CHANNEL_ID, (class_2540)byteBuf);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        super.writeNbt(nbt);
        nbt.method_10556("trigger_held", this.triggerHeld);
        nbt.method_10569("blocks_remaining", this.blocksRemaining);
        nbt.method_10566("enchantments", (class_2520)this.enchantments);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        super.readNbt(nbt);
        this.triggerHeld = nbt.method_10577("trigger_held");
        this.blocksRemaining = nbt.method_10550("blocks_remaining");
        this.enchantments = nbt.method_10554("enchantments", 10);
    }

    public Matrix4f getTransform() {
        return this.transform;
    }

    public boolean triggerHeld() {
        return this.triggerHeld;
    }

    @Override
    protected boolean consume(class_1263 inventory, class_1657 player) {
        this.cooldown = 10;
        return this.consume(1, inventory, player);
    }

    public static interface SetBreakProgress {
        public void setBreakProgress(boolean var1, class_2338 var2, float var3);
    }
}

