/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.client.screen;

import com.neep.meatlib.client.screen.BetterHandledScreen;
import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.auto.Anchor;
import com.neep.meatlib.client.screen.auto.BlackBackgroundPanel;
import com.neep.meatlib.client.screen.auto.BorderPanel;
import com.neep.meatlib.client.screen.auto.Divide;
import com.neep.meatlib.client.screen.auto.EmptyElement;
import com.neep.meatlib.client.screen.auto.HStackPanel;
import com.neep.meatlib.client.screen.auto.HashedBackgroundPanel;
import com.neep.meatlib.client.screen.auto.SimplePanel;
import com.neep.meatlib.client.screen.auto.SplitPanel;
import com.neep.meatlib.client.screen.widget.CheckboxWidget;
import com.neep.meatlib.client.screen.widget.ClickableWidget;
import com.neep.meatlib.client.screen.widget.IntNumberTextField;
import com.neep.meatlib.client.screen.widget.config.ConfigPanel;
import com.neep.meatlib.client.screen.widget.config.MultiLineConfigTextField;
import com.neep.meatlib.screen.ScreenReady;
import com.neep.neepbus.block.entity.MouthBlockEntity;
import com.neep.neepbus.client.screen.OpenNEEPBusConfigButton;
import com.neep.neepbus.screen.MouthScreenHandler;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.button.NMButtonWidget;
import com.neep.neepmeat.client.screen.button.OpenGuideButton;
import com.neep.neepmeat.client.sound.NEEPSpeakSoundInstance;
import com.neep.neepspeak.NEEPSpeakException;
import java.util.Objects;
import net.minecraft.class_1113;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class MouthScreen
extends BetterHandledScreen<MouthScreenHandler> {
    private final HashedBackgroundPanel main;
    private final MouthConfigPanel config;

    public MouthScreen(MouthScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.config = new MouthConfigPanel(handler.handler);
        OpenNEEPBusConfigButton neepBusButton = new OpenNEEPBusConfigButton(() -> handler.openConfigC2S.emitter().run());
        OpenGuideButton guideButton = new OpenGuideButton("automatic_mouth");
        this.main = new HashedBackgroundPanel(new SplitPanel(SplitPanel.Split.VERTICAL, 0).separation().setLeft(new BlackBackgroundPanel(new SplitPanel(SplitPanel.Split.VERTICAL, 0).setDivide(new Divide.Abs(Anchor.END, 16)).setLeft(this.config.textField).setRight(new SplitPanel(SplitPanel.Split.HORIZONTAL, 0).setDivide(new Divide.Abs(Anchor.START, 32)).setLeft(new NMButtonWidget(0, 0, 100, 16, (class_2561)NeepMeat.translationKey("screen", "mouth.trigger"), b -> {
            this.config.update();
            handler.handler.sayC2S.emitter().run();
        }).showBackground(false)).setRight(new BorderPanel(this.config.errorField)).separation()))).setRight(new BlackBackgroundPanel(new SplitPanel(SplitPanel.Split.VERTICAL, 0).setDivide(new Divide.Abs(Anchor.END, 16)).setLeft(this.config).setRight(new HStackPanel(0, 1).addChild(guideButton).addChild(neepBusButton)))));
    }

    @Override
    protected void method_25426() {
        this.field_2792 = 200;
        this.field_2779 = 166;
        super.method_25426();
        this.method_37063(this.main);
        this.main.setDims(this.field_2776, this.field_2800, this.field_2792, this.field_2779);
        ScreenReady.ready();
    }

    public static class MouthConfigPanel
    extends ConfigPanel<MouthScreenHandler.Values> {
        public final MultiLineConfigTextField textField;
        private final ErrorField errorField = new ErrorField();
        private final IntNumberTextField radius;
        private boolean setAutoSay;
        private boolean setPhonetic;

        public MouthConfigPanel(MouthScreenHandler.MouthConfigPanelHandler handler) {
            super(handler);
            this.textField = new MultiLineConfigTextField(this.textRenderer, 0, 0, 100, 18, w -> this.update());
            CheckboxWidget autoSay = this.addTrackedField(new CheckboxWidget(0, 0, 100, 12, () -> this.setAutoSay, (class_2561)NeepMeat.translationKey("screen", "mouth.auto_say"), (button, toggled) -> {
                this.setAutoSay = toggled;
                this.update();
            }));
            CheckboxWidget phonetic = this.addTrackedField(new CheckboxWidget(0, 0, 100, 12, () -> this.setPhonetic, (class_2561)NeepMeat.translationKey("screen", "mouth.phonetic"), (button, toggled) -> {
                this.setPhonetic = toggled;
                this.update();
            }));
            this.radius = this.addTrackedField(new IntNumberTextField(this.textRenderer, 0, 0, 100, 12, (class_2561)NeepMeat.translationKey("screen", "mouth.radius"), f -> this.update(), 0, 50));
            handler.errorS2C.receiver(this::setError);
        }

        private void setError(String error) {
            this.errorField.error = error;
        }

        public void play() {
            class_310 client = class_310.method_1551();
            try {
                client.method_1483().method_4873((class_1113)new NEEPSpeakSoundInstance(MouthBlockEntity.parse(this.textField.parse(), this.setPhonetic), client.field_1724.method_33571(), false));
            }
            catch (NEEPSpeakException e) {
                this.setError(e.getMessage());
            }
        }

        @Override
        protected MouthScreenHandler.Values createValues() {
            return new MouthScreenHandler.Values(this.textField.parse(), this.setAutoSay, this.setPhonetic, this.radius.parse());
        }

        @Override
        protected void updateParams(MouthScreenHandler.Values values) {
            this.textField.setTextSilent(values.message());
            this.setAutoSay = values.autoSay();
            this.setPhonetic = values.phonetic();
            this.radius.setNumberText(values.radius());
        }

        private class ErrorField
        extends SimplePanel {
            private String error = "";

            private ErrorField() {
            }

            @Override
            protected ClickableWidget initMainElement() {
                return new EmptyElement();
            }

            @Override
            public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
                super.method_25394(context, mouseX, mouseY, delta);
                context.method_44379(this.x(), this.y(), this.x2(), this.y2());
                class_5250 text = this.error.isEmpty() ? NeepMeat.translationKey("screen", "mouth.no_error") : class_2561.method_30163((String)this.error);
                class_327 class_3272 = MouthConfigPanel.this.textRenderer;
                float f = this.x + 1;
                float f2 = this.y;
                int n = this.h();
                Objects.requireNonNull(MouthConfigPanel.this.textRenderer);
                GUIUtil.drawText(context, class_3272, (class_2561)text, f, f2 + (float)(n - 9) / 2.0f, PLCCols.TEXT.col, false);
                context.method_44380();
            }
        }
    }
}

