/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.util;

import com.neep.neepbus.util.ReadPort;
import com.neep.neepbus.util.WritePort;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public final class PortMap {
    public static final PortMap EMPTY = new PortMap(Map.of(), Map.of(), new String[0], new WritePort[0], new String[0], new ReadPort[0]);
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final WritePort[] EMPTY_WRITE = new WritePort[0];
    private static final ReadPort[] EMPTY_READ = new ReadPort[0];
    private final Map<String, WritePort> writeMap;
    private final Map<String, ReadPort> readMap;
    private final String[] writeAddresses;
    private final WritePort[] writePorts;
    private final String[] readAddresses;
    private final ReadPort[] readPorts;

    public PortMap(Map<String, WritePort> writeMap, Map<String, ReadPort> readMap, String[] writeAddresses, WritePort[] writePorts, String[] readAddresses, ReadPort[] readPorts) {
        this.writeMap = writeMap;
        this.readMap = readMap;
        this.writeAddresses = writeAddresses;
        this.writePorts = writePorts;
        this.readAddresses = readAddresses;
        this.readPorts = readPorts;
    }

    public static PortMap arrayMap(String[] writeAddresses, WritePort[] writePorts, String[] readAddresses, ReadPort[] readPorts) {
        Object2ObjectArrayMap writePortMap = new Object2ObjectArrayMap((Object[])writeAddresses, (Object[])writePorts);
        Object2ObjectArrayMap readPortMap = new Object2ObjectArrayMap((Object[])readAddresses, (Object[])readPorts);
        return new PortMap((Map<String, WritePort>)writePortMap, (Map<String, ReadPort>)readPortMap, writeAddresses, writePorts, readAddresses, readPorts);
    }

    public PortMap delegate(int i) {
        String writeAddress = this.writeAddresses[i];
        String readAddress = this.readAddresses[i];
        WritePort writePort = this.writePorts[i];
        ReadPort readPort = this.readPorts[i];
        return new PortMap((Map<String, WritePort>)Object2ObjectMaps.singleton((Object)writeAddress, (Object)writePort), (Map<String, ReadPort>)Object2ObjectMaps.singleton((Object)readAddress, (Object)readPort), EMPTY_STRINGS, EMPTY_WRITE, EMPTY_STRINGS, EMPTY_READ);
    }

    public Map<String, WritePort> writeMap() {
        return this.writeMap;
    }

    public Map<String, ReadPort> readMap() {
        return this.readMap;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PortMap that = (PortMap)obj;
        return Objects.equals(this.writeMap, that.writeMap) && Objects.equals(this.readMap, that.readMap) && Arrays.equals(this.writeAddresses, that.writeAddresses) && Arrays.equals(this.writePorts, that.writePorts) && Arrays.equals(this.readAddresses, that.readAddresses) && Arrays.equals(this.readPorts, that.readPorts);
    }

    public int hashCode() {
        return Objects.hash(this.writeMap, this.readMap, this.writeAddresses, this.writePorts, this.readAddresses, this.readPorts);
    }

    public String toString() {
        return "PortMap[writeMap=" + String.valueOf(this.writeMap) + ", readMap=" + String.valueOf(this.readMap) + ", writeAddresses=" + String.valueOf(this.writeAddresses) + ", writePorts=" + String.valueOf(this.writePorts) + ", readAddresses=" + String.valueOf(this.readAddresses) + ", readPorts=" + String.valueOf(this.readPorts) + "]";
    }
}

