/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.multiblock2;

import com.neep.meatlib.registry.RegistrationContext;
import com.neep.neepmeat.api.big_block.BigBlockPattern;
import com.neep.neepmeat.api.multiblock2.MultiBlockStructure;
import com.neep.neepmeat.api.multiblock2.MultiblockUnassembledPattern;
import com.neep.neepmeat.init.NMSounds;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public abstract class Multiblock2ControllerBlock<T extends MultiBlockStructure<?>>
extends class_2248 {
    private final T structureBlock;
    public static final class_2746 ASSEMBLED = class_2746.method_11825((String)"assembled");

    public Multiblock2ControllerBlock(RegistrationContext ctx, class_4970.class_2251 settings) {
        super(settings);
        this.structureBlock = this.registerStructureBlock(ctx);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)ASSEMBLED, (Comparable)Boolean.valueOf(false)));
    }

    protected abstract BigBlockPattern getAssembledPattern(class_2680 var1);

    protected abstract MultiblockUnassembledPattern getUnassembledPattern(class_2680 var1);

    protected abstract T registerStructureBlock(RegistrationContext var1);

    public T getStructure() {
        return this.structureBlock;
    }

    public class_265 getAssembledShape(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.method_9530(state, world, pos, context);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (this.assemble(world, pos, state)) {
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public boolean assemble(class_1937 world, class_2338 controllerPos, class_2680 state) {
        MultiblockUnassembledPattern assemblePattern = this.getUnassembledPattern(state);
        if (assemblePattern.test(world, controllerPos) && this.checkSpaceForAssembly(world, controllerPos, state)) {
            this.getAssembledPattern(state).placeBlocks(world, controllerPos, controllerPos);
            world.method_8501(controllerPos, (class_2680)state.method_11657((class_2769)ASSEMBLED, (Comparable)Boolean.valueOf(true)));
            world.method_45447(null, controllerPos, NMSounds.MULTIBLOCK_ASSEMBLE, class_3419.field_15245);
            return true;
        }
        return false;
    }

    public void disassemble(class_1937 world, class_2338 controllerPos, class_2680 state, class_2338 origin) {
        MultiblockUnassembledPattern pattern = this.getUnassembledPattern(state);
        pattern.placeBlocks(world, controllerPos, controllerPos);
        world.method_45447(null, origin, NMSounds.MULTIBLOCK_DISASSEMBLE, class_3419.field_15245);
    }

    protected boolean checkSpaceForAssembly(class_1937 world, class_2338 origin, class_2680 state) {
        BigBlockPattern pattern = this.getAssembledPattern(state);
        class_2338.class_2339 mutable = origin.method_25503();
        for (Pair<class_2382, class_2680> entry : pattern.entries()) {
            mutable.method_35831((class_2382)origin, (class_2382)entry.key());
            if (!world.method_8320((class_2338)mutable).method_27852(this.structureBlock)) continue;
            return false;
        }
        return true;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!newState.method_27852((class_2248)this) && ((Boolean)state.method_11654((class_2769)ASSEMBLED)).booleanValue()) {
            this.disassemble(world, pos, state, pos);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ASSEMBLED});
    }
}

