/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.screen_handler.DisplayPlateScreenHandler;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;

public class DisplayPlateBlockEntity
extends SyncableBlockEntity
implements ExtendedScreenHandlerFactory {
    protected int capacity = 1;
    protected final WritableStackStorage storage;
    protected final MutateInPlace<class_1799> mip = new Mutate();
    protected final Delegate delegate = new Delegate();
    public float stackRenderDelta;

    public DisplayPlateBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.storage = new WritableStackStorage(this::sync, 1){

            @Override
            protected void onFinalCommit() {
                super.onFinalCommit();
            }

            @Override
            protected long getCapacity(ItemVariant variant) {
                if (!variant.isBlank()) {
                    return Math.min(variant.getItem().method_7882(), DisplayPlateBlockEntity.this.capacity);
                }
                return DisplayPlateBlockEntity.this.capacity;
            }
        };
    }

    public DisplayPlateBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.ITEM_BUFFER_BLOCK_ENTITY, pos, state);
    }

    public WritableStackStorage getStorage(@Nullable class_2350 direction) {
        return this.storage;
    }

    public MutateInPlace<class_1799> getMip(Void ctx) {
        return this.mip;
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.storage.writeNbt(tag);
        tag.method_10569("capacity", this.capacity);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt);
        this.capacity = nbt.method_10550("capacity");
    }

    public void extractFromItem(class_1542 itemEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        if (itemStack.method_7960()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            int transferred = (int)this.storage.insert((TransferVariant)ItemVariant.of((class_1799)itemStack), itemStack.method_7947(), (TransactionContext)transaction);
            itemStack.method_7934(transferred);
            if (itemStack.method_7947() <= 0) {
                itemEntity.method_31472();
            }
            transaction.commit();
        }
    }

    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new DisplayPlateScreenHandler(playerInventory, syncId, this.delegate, this.capacity);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.writeInt(this.capacity);
    }

    protected class Mutate
    implements MutateInPlace<class_1799> {
        protected Mutate() {
        }

        @Override
        public class_1799 get() {
            return DisplayPlateBlockEntity.this.storage.getAsStack().method_46651(1);
        }

        @Override
        public void set(class_1799 stack) {
            DisplayPlateBlockEntity.this.storage.setStack(stack);
        }

        @Override
        public void setResult(int consumed, class_1799 stack) {
            if (!DisplayPlateBlockEntity.this.storage.isEmpty()) {
                if (DisplayPlateBlockEntity.this.storage.amount >= (long)consumed) {
                    DisplayPlateBlockEntity.this.storage.extractDirect(consumed);
                }
                if (DisplayPlateBlockEntity.this.storage.amount > 0L) {
                    MeatlibStorageUtil.scatter(DisplayPlateBlockEntity.this.field_11863, DisplayPlateBlockEntity.this.field_11867, (Storage<ItemVariant>)DisplayPlateBlockEntity.this.storage);
                }
            }
            this.set(stack);
        }
    }

    private class Delegate
    implements class_3913 {
        private Delegate() {
        }

        public int method_17390(int index) {
            if (index == 0) {
                return DisplayPlateBlockEntity.this.capacity;
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                DisplayPlateBlockEntity.this.capacity = class_3532.method_15340((int)value, (int)0, (int)8);
            }
        }

        public int method_17389() {
            return 1;
        }
    }
}

