/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.renderer;

import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.mixin.BlockModelRendererAccessor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.BitSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_777;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

@Environment(value=EnvType.CLIENT)
public class BERenderUtils {
    public static void renderModelSmooth(class_2960 model, class_4587 matrices, class_1937 world, class_2338 pos, class_4597 vertexConsumers) {
        class_1092 manager = class_310.method_1551().method_1541().method_3351().method_3333();
        class_1087 handle = manager.getModel(model);
        class_778 renderer = class_310.method_1551().method_1541().method_3350();
        BERenderUtils.renderSmooth(renderer, (class_1920)world, handle, pos, matrices, vertexConsumers.getBuffer(class_1921.method_23581()), class_5819.method_43047(), 0L, 0);
    }

    public static void renderSmooth(class_778 renderer, class_1920 world, class_1087 model, class_2338 pos, class_4587 matrices, class_4588 vertexConsumer, class_5819 random, long seed, int overlay) {
        BlockModelRendererAccessor accessor = (BlockModelRendererAccessor)renderer;
        float[] fs = new float[class_2350.values().length * 2];
        BitSet bitSet = new BitSet(3);
        class_778.class_780 ambientOcclusionCalculator = new class_778.class_780();
        class_2680 state = class_2246.field_10124.method_9564();
        for (class_2350 direction : class_2350.values()) {
            random.method_43052(seed);
            List list = model.method_4707(state, direction, random);
            if (list.isEmpty()) continue;
            accessor.callRenderQuadsSmooth(world, state, pos, matrices, vertexConsumer, list, fs, bitSet, ambientOcclusionCalculator, overlay);
        }
        random.method_43052(seed);
        List list2 = model.method_4707(state, null, random);
        if (!list2.isEmpty()) {
            accessor.callRenderQuadsSmooth(world, state, pos, matrices, vertexConsumer, list2, fs, bitSet, ambientOcclusionCalculator, overlay);
        }
    }

    public static void renderModel(class_2960 model, class_4587 matrices, class_1937 world, class_2338 pos, class_2680 state, class_4597 vertexConsumers) {
        class_1092 manager = class_310.method_1551().method_1541().method_3351().method_3333();
        class_1087 handle = manager.getModel(model);
        class_778 renderer = class_310.method_1551().method_1541().method_3350();
        BERenderUtils.renderFlat(renderer, (class_1920)world, handle, state, pos, matrices, vertexConsumers.getBuffer(class_1921.method_23581()), true, class_5819.method_43047(), 0L, 0);
    }

    private static void renderFlat(class_778 renderer, class_1920 world, class_1087 model, class_2680 state, class_2338 pos, class_4587 matrices, class_4588 vertexConsumer, boolean cull, class_5819 random, long seed, int overlay) {
        BitSet bitSet = new BitSet(3);
        random.method_43052(seed);
        List list2 = model.method_4707(state, null, random);
        if (!list2.isEmpty()) {
            BERenderUtils.renderQuadsFlat(renderer, world, state, pos, -1, overlay, true, matrices, vertexConsumer, list2, bitSet);
        }
    }

    private static void renderQuadsFlat(class_778 renderer, class_1920 world, class_2680 state, class_2338 pos, int light, int overlay, boolean useWorldLight, class_4587 matrices, class_4588 vertexConsumer, List<class_777> quads, BitSet flags) {
        BlockModelRendererAccessor accessor = (BlockModelRendererAccessor)renderer;
        for (class_777 bakedQuad : quads) {
            if (useWorldLight) {
                light = class_761.method_23793((class_1920)world, (class_2680)state, (class_2338)pos);
            }
            float brightness = 1.0f;
            accessor.callRenderQuad(world, state, pos, vertexConsumer, matrices.method_23760(), bakedQuad, brightness, brightness, brightness, brightness, light, light, light, light, overlay);
        }
    }

    public static class_2350 nearestDirection(Vector3f vec) {
        class_2350 closest = class_2350.field_11043;
        float closestDist = 100.0f;
        for (class_2350 direction : class_2350.values()) {
            Vector3f vec1 = closest.method_23955();
            vec1.sub((Vector3fc)vec);
            float len = vec1.length();
            if (!(len < closestDist)) continue;
            closest = direction;
            closestDist = len;
        }
        return class_2350.field_11036;
    }

    public static void rotateFacing(class_2350 facing, class_4587 matrices) {
        matrices.method_22904(0.5, 0.5, 0.5);
        switch (facing) {
            case field_11035: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11043: {
                break;
            }
            case field_11034: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
                break;
            }
            case field_11033: {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                break;
            }
            case field_11036: {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            }
        }
        matrices.method_22904(-0.5, -0.5, -0.5);
    }

    public static void rotateFacingSouth(class_2350 facing, class_4587 matrices) {
        matrices.method_22904(0.5, 0.5, 0.5);
        switch (facing) {
            case field_11043: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11034: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11035: {
                break;
            }
            case field_11039: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
                break;
            }
            case field_11036: {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                break;
            }
            case field_11033: {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            }
        }
        matrices.method_22904(-0.5, -0.5, -0.5);
    }

    public static void renderFluidCuboid(class_4597 vcp, class_4587 matrices, FluidVariant fluid, float startY, float endY, float depth, float scaleY, int light) {
        if (NMFluids.isGas(fluid)) {
            BERenderUtils.renderGas(vcp, matrices, fluid, startY, endY, depth, scaleY, light);
            return;
        }
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        class_4588 consumer = vcp.getBuffer(class_1921.method_23583());
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        int col = FluidVariantRendering.getColor((FluidVariant)fluid);
        float r = (float)(col >> 16 & 0xFF) / 256.0f;
        float g = (float)(col >> 8 & 0xFF) / 256.0f;
        float b = (float)(col & 0xFF) / 256.0f;
        if (fluid.isBlank() || scaleY == 0.0f) {
            return;
        }
        float dist = startY + (endY - startY) * scaleY;
        if (FluidVariantAttributes.isLighterThanAir((FluidVariant)fluid)) {
            matrices.method_46416(1.0f, 1.0f, 0.0f);
            matrices.method_22905(-1.0f, -1.0f, 1.0f);
        }
        QuadEmitter emitter = renderer.meshBuilder().getEmitter();
        for (class_2350 direction : class_2350.values()) {
            if (direction.method_10166().method_10178()) {
                emitter.square(direction, depth, depth, 1.0f - depth, 1.0f - depth, direction == class_2350.field_11036 ? 1.0f - dist : startY);
            } else if (direction != class_2350.field_11033) {
                emitter.square(direction, depth, startY, 1.0f - depth, dist, depth);
            }
            emitter.spriteBake(0, sprite, 4);
            emitter.spriteColor(0, -1, -1, -1, -1);
            consumer.method_22919(matrices.method_23760(), emitter.toBakedQuad(0, sprite, false), r, g, b, light, class_4608.field_21444);
        }
    }

    public static void renderGas(class_4597 vcp, class_4587 matrices, FluidVariant fluid, float startY, float endY, float depth, float scaleY, int light) {
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        class_4588 consumer = vcp.getBuffer(class_1921.method_23583());
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        int col = FluidVariantRendering.getColor((FluidVariant)fluid);
        float r = (float)(col >> 16 & 0xFF) / 256.0f;
        float g = (float)(col >> 8 & 0xFF) / 256.0f;
        float b = (float)(col & 0xFF) / 256.0f;
        if (fluid.isBlank() || scaleY == 0.0f) {
            return;
        }
        QuadEmitter emitter = renderer.meshBuilder().getEmitter();
        for (class_2350 direction : class_2350.values()) {
            if (direction.method_10166().method_10178()) {
                emitter.square(direction, depth, depth, 1.0f - depth, 1.0f - depth, direction == class_2350.field_11036 ? 1.0f - endY : startY);
            } else if (direction != class_2350.field_11033) {
                emitter.square(direction, depth, startY, 1.0f - depth, endY, depth);
            }
            float alpha = class_3532.method_15363((float)scaleY, (float)0.0f, (float)1.0f);
            int colWithAlpha = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            emitter.spriteBake(0, sprite, 4);
            BERenderUtils.quad(consumer, matrices.method_23760(), emitter.toBakedQuad(0, sprite, false), 1.0f, r, g, b, alpha, light);
        }
    }

    private static void quad(class_4588 consumer, class_4587.class_4665 matrixEntry, class_777 quad, float brightness, float red, float green, float blue, float alpha, int light) {
        Vector3f unit = quad.method_3358().method_23955();
        Matrix4f matrix4f = matrixEntry.method_23761();
        Vector3f vector3f = matrixEntry.method_23762().transform(unit);
        int[] js = quad.method_3357();
        int j = js.length / 8;
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(class_290.field_1590.method_1362());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                intBuffer.clear();
                intBuffer.put(js, k * 8, 8);
                float f = byteBuffer.getFloat(0);
                float g = byteBuffer.getFloat(4);
                float h = byteBuffer.getFloat(8);
                float o = brightness * red;
                float p = brightness * green;
                float q = brightness * blue;
                float s = brightness * alpha;
                float m = byteBuffer.getFloat(16);
                float n = byteBuffer.getFloat(20);
                Vector4f vector4f = matrix4f.transform(new Vector4f(f, g, h, 1.0f));
                consumer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), o, p, q, s, m, n, class_4608.field_21444, light, vector3f.x(), vector3f.y(), vector3f.z());
            }
        }
    }
}

