/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.living_machine;

import com.neep.meatlib.client.screen.primitive.MutableRectangle;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.BaseHandledScreen;
import com.neep.neepmeat.client.screen.ScreenSubElement;
import com.neep.neepmeat.client.screen.living_machine.GraphPane;
import com.neep.neepmeat.client.screen.living_machine.MetricsPane;
import com.neep.neepmeat.client.screen.living_machine.ProcessesPane;
import com.neep.neepmeat.client.screen.util.Border;
import com.neep.neepmeat.screen_handler.LivingMachineScreenHandler;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_634;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class LivingMachineScreen
extends BaseHandledScreen<LivingMachineScreenHandler> {
    private final GraphPane graphPane;
    private final MetricsPane metricsPane;
    private final ProcessesPane processesPane;
    private PaneWidget leftPane;

    public LivingMachineScreen(LivingMachineScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.metricsPane = new MetricsPane(handler, this);
        this.processesPane = new ProcessesPane(this);
        this.graphPane = new GraphPane(handler);
        this.leftPane = this.metricsPane;
        ClientPlayNetworking.registerReceiver((class_2960)LivingMachineScreenHandler.GRAPH_SYNC_ID, this::receive);
    }

    void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_2540 copy = PacketByteBufs.copy((ByteBuf)buf);
        client.execute(() -> this.graphPane.update(copy));
    }

    protected void method_25426() {
        this.field_2792 = 400;
        this.field_2779 = 200;
        super.method_25426();
        Border mainBorder = (Border)this.method_37060(new Border(this.field_2776, this.field_2800, this.field_2792, this.field_2779, 2, () -> PLCCols.BORDER.col));
        Rectangle withoutPadding = mainBorder.withoutPadding();
        float fraction = 0.4f;
        int metricsWidth = (int)(fraction * (float)withoutPadding.w());
        int graphsWidth = (int)((1.0f - fraction) * (float)withoutPadding.w());
        this.metricsPane.init(new MutableRectangle(withoutPadding).setW(metricsWidth));
        this.processesPane.init(new MutableRectangle(withoutPadding).setW(metricsWidth));
        this.method_37063(this.leftPane);
        this.graphPane.init(new Rectangle.Immutable(this.metricsPane.border.x() + this.metricsPane.border.w() + 1, withoutPadding.y(), graphsWidth, withoutPadding.h()));
        this.method_37063(this.graphPane);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.leftPane.method_25402(mouseX, mouseY, button) || super.method_25402(mouseX, mouseY, button);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        super.method_25420(context);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
    }

    protected void method_37432() {
        super.method_37432();
        this.metricsPane.tick();
        this.graphPane.tick();
    }

    public void method_25419() {
        super.method_25419();
        ClientPlayNetworking.unregisterReceiver((class_2960)LivingMachineScreenHandler.GRAPH_SYNC_ID);
    }

    public void switchMode() {
        this.leftPane = this.leftPane == this.processesPane ? this.metricsPane : this.processesPane;
        this.method_41843();
    }

    static abstract class PaneWidget
    extends ScreenSubElement
    implements class_6379 {
        protected boolean focused;
        protected Rectangle bounds;
        protected Border border;

        PaneWidget() {
        }

        public void init(Rectangle parentSize) {
            this.bounds = new Rectangle.Immutable(parentSize);
            this.border = new Border(this.bounds, 0, () -> PLCCols.BORDER.col);
            this.clearChildren();
            this.init();
        }

        @Override
        protected void init() {
        }

        @Override
        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_25394(context, mouseX, mouseY, delta);
            this.border.method_25394(context, mouseX, mouseY, delta);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return this.bounds.isWithin(mouseX, mouseY);
        }

        public void method_25365(boolean focused) {
            this.focused = focused;
        }

        public boolean method_25370() {
            return this.focused;
        }

        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 builder) {
        }
    }
}

