/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.plc.edit;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.plc.MonoTextRenderer;
import com.neep.neepmeat.client.screen.plc.edit.EditBox;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_7528;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class EditBoxWidget
extends class_7528 {
    private final MonoTextRenderer textRenderer;
    protected final EditBox editBox;
    @Nullable
    private String errorMessage;
    private int errorCol = -1;
    private final float scale;
    private int errorLine = -1;
    private int debugLine = -1;
    private final class_2561 placeholder;
    protected boolean renderLineNumber = true;
    private float lineNumberWidth;

    public EditBoxWidget(int x, int y, int width, int height, float scale, class_2561 placeholder) {
        super(x, y, width, height, class_2561.method_30163((String)"gle"));
        this.scale = scale;
        this.placeholder = placeholder;
        this.textRenderer = new MonoTextRenderer();
        this.updateLineNumber();
        this.editBox = new EditBox(this.textRenderer, (int)((float)(width - this.method_44385()) - this.lineNumberWidth), scale);
        this.editBox.setCursorChangeListener(this::onCursorChange);
    }

    public void setRenderLineNumber(boolean renderLineNumber) {
        this.renderLineNumber = renderLineNumber;
        this.updateLineNumber();
    }

    private void updateLineNumber() {
        this.lineNumberWidth = this.renderLineNumber ? (float)(this.textRenderer.getWidth("11") + 4) : 0.0f;
    }

    public void setMaxLength(int maxLength) {
        this.editBox.setMaxLength(maxLength);
    }

    public void setChangeListener(Consumer<String> changeListener) {
        this.editBox.setChangeListener(changeListener);
    }

    public String getText() {
        return this.editBox.getText();
    }

    public void insert(String s) {
        EditBox.Substring selection = this.editBox.getSelection();
        if (!this.editBox.getText().isEmpty() && !Character.isWhitespace(this.editBox.getText().charAt(Math.max(0, selection.beginIndex() - 1)))) {
            s = " " + (String)s;
        }
        this.editBox.replaceSelection((String)s);
    }

    public void setText(String text) {
        this.editBox.setText(text);
    }

    public void tick() {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean bl2;
        boolean bl = bl2 = this.method_44392() && mouseX >= (double)(this.method_46426() + this.field_22758) && mouseX <= (double)(this.method_46426() + this.field_22758 + 8) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
        if (this.method_44388(mouseX, mouseY) && bl2) {
            return super.method_25402(mouseX, mouseY, button);
        }
        if (this.method_44388(mouseX, mouseY) && button == 0) {
            this.editBox.setSelecting(class_437.method_25442());
            this.moveCursor(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.method_44388(mouseX, mouseY) && button == 0) {
            this.editBox.setSelecting(true);
            this.moveCursor(mouseX, mouseY);
            this.editBox.setSelecting(class_437.method_25442());
            return true;
        }
        return false;
    }

    protected void method_47399(class_6382 builder) {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.editBox.handleSpecialKey(keyCode);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.field_22764 && this.method_25370() && class_155.method_643((char)chr)) {
            this.editBox.replaceSelection(Character.toString(chr));
            return true;
        }
        return false;
    }

    private int textCol() {
        return PLCCols.TEXT.col;
    }

    private int selCol() {
        return PLCCols.SELECTED.col;
    }

    private int borderCol() {
        return PLCCols.BORDER.col;
    }

    private int cursorCol() {
        return PLCCols.SELECTED.col;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrices = context.method_51448();
        int x = this.method_46426();
        int y = this.method_46427();
        if (this.field_22764) {
            int col = !this.method_25370() ? PLCCols.INVALID.col : PLCCols.SELECTED.col;
            context.method_25294(x + 1, y + 1, x + this.field_22758 - 1, y + this.field_22759 - 1, -1879048192);
            GUIUtil.renderBorder(context, x, y, this.field_22758 - 1, this.field_22759 - 1, col, 0);
            context.method_44379(x + 1, y + 1, x + this.field_22758 - 1, y + this.field_22759 - 1);
            if (this.errorMessage != null) {
                List<class_5481> errorLines = this.textRenderer.wrapLines(class_5348.method_29430((String)this.errorMessage), 360);
                matrices.method_22903();
                float bottom = (float)((double)(y + this.field_22759) - this.lineHeight() * (double)errorLines.size() - (double)this.method_44381());
                matrices.method_46416(0.0f, bottom, 0.0f);
                matrices.method_22905(this.scale, this.scale, 1.0f);
                for (class_5481 line : errorLines) {
                    this.textRenderer.draw(matrices, line, (float)(x + this.method_44381()), 0.0f, this.errorCol);
                    matrices.method_46416(0.0f, (float)this.textRenderer.fontHeight(), 0.0f);
                }
                matrices.method_22909();
            }
            matrices.method_22903();
            matrices.method_22904(0.0, -this.method_44387(), 0.0);
            this.renderHighlightLine(context, this.errorLine, PLCCols.ERROR_LINE.col);
            this.renderHighlightLine(context, this.debugLine, PLCCols.DEBUG_LINE.col);
            this.method_44389(context, mouseX, mouseY, delta);
            matrices.method_22909();
            context.method_44380();
            this.renderOverlay(matrices);
        }
    }

    protected void renderHighlightLine(class_332 matrices, int line, int col) {
        if (line >= 0) {
            double lineStart = (double)(this.method_46427() + this.method_44381()) + (double)this.editBox.absLineToWrapped(line) * this.lineHeight();
            matrices.method_25294(this.method_46426() + this.method_44381(), (int)lineStart, this.method_46426() + this.field_22758 - this.method_44381(), (int)(lineStart + this.lineHeight()), col);
        }
    }

    protected void method_44389(class_332 context, int mouseX, int mouseY, float delta) {
        int i;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        String string = this.editBox.getText();
        if (string.isEmpty() && !this.method_25370()) {
            i = 0;
            for (class_5481 line : this.textRenderer.wrapLines((class_5348)this.placeholder, this.field_22758)) {
                matrices.method_22903();
                matrices.method_22904(0.0, (double)i * this.lineHeight(), 0.0);
                matrices.method_22905(this.scale, this.scale, 1.0f);
                this.textRenderer.draw(matrices, line, (float)(this.method_46426() + this.method_44381()), (float)(this.method_46427() + this.method_44381()), PLCCols.TEXT.col);
                matrices.method_22909();
                ++i;
            }
        }
        i = this.editBox.getCursor();
        boolean cursorVisible = this.method_25370();
        boolean inBounds = i <= string.length();
        float j = 0.0f;
        float k = 0.0f;
        float l = this.method_46427() + this.method_44381();
        int numLines = 0;
        Iterator<EditBox.LineEntry> it = this.editBox.getLines().iterator();
        while (it.hasNext()) {
            matrices.method_22903();
            EditBox.LineEntry substring = it.next();
            boolean lineVisible = this.method_44383((int)l, (int)((double)l + this.lineHeight()));
            matrices.method_46416((float)(this.method_46426() + this.method_44381()), l, 0.0f);
            if (this.renderLineNumber && !this.editBox.getText().isEmpty() && !substring.wrapped()) {
                matrices.method_22903();
                matrices.method_22905(this.scale, this.scale, 1.0f);
                this.textRenderer.draw(matrices, class_2561.method_30163((String)String.valueOf(numLines)).method_30937(), 0.0f, 0.0f, PLCCols.LINE_NUMBER.col);
                ++numLines;
                matrices.method_22909();
            }
            if (lineVisible) {
                matrices.method_22903();
                matrices.method_22905(this.scale, this.scale, 1.0f);
                matrices.method_46416(this.lineNumberWidth, 0.0f, 0.0f);
                String sub = string.substring(substring.beginIndex(), substring.endIndex());
                if (cursorVisible && inBounds && i >= substring.beginIndex() && i <= substring.endIndex()) {
                    float cursorOffset = this.textRenderer.getWidth(string.substring(substring.beginIndex(), i));
                    context.method_25294((int)(cursorOffset - 1.0f), 0, (int)cursorOffset, this.textRenderer.fontHeight(), this.cursorCol());
                }
                String[] strings = sub.split("(?=#)");
                j = 0.0f;
                for (int m = 0; m < strings.length; ++m) {
                    j += this.textRenderer.drawWithShadow(matrices, strings[m], j, 0.0f, m == 0 && !strings[m].startsWith("#") ? this.textCol() : -10066330) - 1.0f;
                }
                matrices.method_22909();
            }
            k = l;
            matrices.method_22909();
            l += (float)this.lineHeight();
        }
        if (cursorVisible && !inBounds && this.method_44383((int)k, (int)((double)k + this.lineHeight()))) {
            matrices.method_22903();
            matrices.method_46416(0.0f, k, 0.0f);
            matrices.method_22905(this.scale, this.scale, 1.0f);
            matrices.method_46416(this.lineNumberWidth, 0.0f, 0.0f);
            context.method_25294((int)(j + 5.0f), 0, (int)j + 10, this.textRenderer.fontHeight(), this.cursorCol());
            matrices.method_22909();
        }
        if (this.editBox.hasSelection()) {
            EditBox.Substring substring2 = this.editBox.getSelection();
            int m = this.method_46426() + this.method_44381();
            l = this.method_46427() + this.method_44381();
            for (EditBox.LineEntry substring3 : this.editBox.getLines()) {
                if (substring2.beginIndex() <= substring3.endIndex()) {
                    if (substring3.beginIndex() > substring2.endIndex()) break;
                    if (this.method_44383((int)l, (int)((double)l + this.lineHeight()))) {
                        int selWidth = this.textRenderer.getWidth(string.substring(substring3.beginIndex(), Math.max(substring2.beginIndex(), substring3.beginIndex())));
                        float o = substring2.endIndex() > substring3.endIndex() ? (float)this.field_22758 / this.scale - (float)this.method_44385() : (float)this.textRenderer.getWidth(string.substring(substring3.beginIndex(), substring2.endIndex()));
                        int selLeft = (int)((float)(m + selWidth) + this.lineNumberWidth);
                        int selRight = (int)((float)m + o + this.lineNumberWidth);
                        matrices.method_22903();
                        matrices.method_46416(0.0f, l, 0.0f);
                        this.drawSelection(matrices, selLeft, 0, selRight, 9);
                        matrices.method_22909();
                    }
                }
                l += (float)this.lineHeight();
            }
        }
        matrices.method_22909();
    }

    protected void renderOverlay(class_4587 matrices) {
    }

    public int method_44391() {
        return (int)(this.lineHeight() * (double)this.editBox.getLineCount());
    }

    protected boolean method_44392() {
        return (double)this.editBox.getLineCount() > this.getMaxLinesWithoutOverflow();
    }

    protected double method_44393() {
        return this.lineHeight() / 2.0;
    }

    private void drawSelection(class_4587 matrices, int left, int top, int right, int bottom) {
        matrices.method_22903();
        matrices.method_22905(this.scale, this.scale, 1.0f);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix4f, (float)left, (float)bottom, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)right, (float)bottom, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)right, (float)top, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)left, (float)top, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableColorLogicOp();
        matrices.method_22909();
    }

    private void onCursorChange() {
        double d = this.method_44387();
        EditBox var10000 = this.editBox;
        EditBox.Substring substring = var10000.getLine((int)(d / this.lineHeight())).substring();
        if (this.editBox.getCursor() <= substring.beginIndex()) {
            int var5 = this.editBox.getCurrentLineIndex();
            d = (double)var5 * this.lineHeight();
        } else {
            double var10001 = d + (double)this.field_22759;
            EditBox.Substring substring2 = var10000.getLine((int)(var10001 / this.lineHeight()) - 1).substring();
            if (this.editBox.getCursor() > substring2.endIndex()) {
                int var5 = this.editBox.getCurrentLineIndex();
                var5 = (int)((double)var5 * this.lineHeight() - (double)this.field_22759);
                d = (double)var5 + this.lineHeight() + (double)this.method_44385();
            }
        }
        this.method_44382(d);
    }

    private double getMaxLinesWithoutOverflow() {
        double height1 = this.field_22759 - this.method_44385();
        return height1 / this.lineHeight();
    }

    private void moveCursor(double mouseX, double mouseY) {
        double d = mouseX - (double)this.method_46426() - ((double)this.method_44381() + (double)(this.lineNumberWidth * this.scale));
        double e = mouseY - (double)this.method_46427() - (double)this.method_44381() + this.method_44387();
        this.editBox.moveCursor(d / (double)this.scale, e / (double)this.scale);
    }

    private double lineHeight() {
        return (float)this.textRenderer.fontHeight() * this.scale;
    }

    public void setHeight(int height) {
        this.field_22759 = height;
    }

    public void setError(String message, int col) {
        this.errorMessage = message;
        this.errorCol = col;
    }

    public void setErrorLine(int line) {
        this.errorLine = line;
    }

    public void setDebugLine(int line) {
        this.debugLine = line;
    }
}

