/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.entity.worm;

import com.neep.meatlib.api.entity.MultiPartEntity;
import com.neep.neepmeat.entity.worm.AbstractWormPart;
import com.neep.neepmeat.entity.worm.WormAction;
import com.neep.neepmeat.entity.worm.WormActions;
import com.neep.neepmeat.entity.worm.WormBiteGoal;
import com.neep.neepmeat.entity.worm.WormFullSwingGoal;
import com.neep.neepmeat.entity.worm.WormTargetGoal;
import com.neep.neepmeat.network.NMTrackedData;
import com.neep.neepmeat.util.Bezier;
import com.neep.neepmeat.util.Easing;
import com.neep.neepmeat.util.NMMaths;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1937;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WormEntity
extends AbstractWormPart
implements MultiPartEntity<WormSegment>,
GeoEntity {
    protected static final class_2940<String> CURRENT_ACTION = class_2945.method_12791(WormEntity.class, (class_2941)class_2943.field_13326);
    protected static final class_2940<Double> HEAD_X = class_2945.method_12791(WormEntity.class, NMTrackedData.DOUBLE);
    protected static final class_2940<Double> HEAD_Y = class_2945.method_12791(WormEntity.class, NMTrackedData.DOUBLE);
    protected static final class_2940<Double> HEAD_Z = class_2945.method_12791(WormEntity.class, NMTrackedData.DOUBLE);
    protected static final class_2940<Float> HEAD_PITCH = class_2945.method_12791(WormEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> HEAD_YAW = class_2945.method_12791(WormEntity.class, (class_2941)class_2943.field_13320);
    private final AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private WormAction currentAction;
    protected List<WormSegment> segments = new ArrayList<WormSegment>(17);
    protected List<WormSegment> tail = new ArrayList<WormSegment>(16);
    public final WormSegment head;
    @Nullable
    protected class_1309 target;
    protected final class_1355 goalSelector;

    public WormEntity(class_1299<? extends WormEntity> type, class_1937 world) {
        super(type, world);
        int length = 16;
        for (int i = 0; i < length; ++i) {
            WormSegment segment = new WormSegment(this, 1.625f, 16.0f);
            this.tail.add(segment);
        }
        this.head = new WormSegment(this, 1.625f, 16.0f);
        this.segments.addAll(this.tail);
        this.segments.add(this.head);
        this.goalSelector = new class_1355(this.method_37908().method_24367());
        if (!this.method_37908().method_8608()) {
            this.initGoals();
        }
    }

    protected void initGoals() {
        this.goalSelector.method_6277(1, (class_1352)new WormTargetGoal(this, class_4051.field_18092, 14.0f));
        this.goalSelector.method_6277(2, (class_1352)new WormFullSwingGoal(this, 8.0f));
        this.goalSelector.method_6277(2, (class_1352)new WormBiteGoal(this));
    }

    public void setTarget(class_1309 target) {
        this.target = target;
    }

    public class_1309 getTarget() {
        return this.target;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CURRENT_ACTION, (Object)WormAction.EmptyAction.ID.toString());
        this.field_6011.method_12784(HEAD_X, (Object)this.method_23317());
        this.field_6011.method_12784(HEAD_Y, (Object)(this.method_23318() + 15.0));
        this.field_6011.method_12784(HEAD_Z, (Object)this.method_23321());
        this.field_6011.method_12784(HEAD_PITCH, (Object)Float.valueOf(-90.0f));
        this.field_6011.method_12784(HEAD_YAW, (Object)Float.valueOf(0.0f));
    }

    public static class_5132.class_5133 createLivingAttributes() {
        return class_1308.method_26828();
    }

    public class_2487 method_5647(class_2487 nbt) {
        super.method_5647(nbt);
        nbt.method_10566("currentAction", (class_2520)WormActions.toNbt(this.currentAction));
        return nbt;
    }

    public void method_5651(class_2487 nbt) {
        super.method_5651(nbt);
        this.currentAction = WormActions.fromNbt(nbt.method_10562("currentAction"), this);
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    public void method_5773() {
        super.method_5773();
        Bezier.Cubic3 bezier = new Bezier.Cubic3(10);
        this.method_36457(-90.0f);
        double y = this.method_23318();
        double x = this.method_23317();
        double z = this.method_23321();
        if (this.method_37908().method_8608()) {
            this.updateHead();
        }
        class_243 headLook = this.head.method_19538().method_1019(class_243.method_1030((float)this.head.method_36455(), (float)this.head.method_36454()).method_1021(-8.0));
        bezier.setPoint(0, x, y, z);
        bezier.setPoint(1, x, y + 5.0, z);
        bezier.setPoint(2, headLook.field_1352, headLook.field_1351, headLook.field_1350);
        bezier.setPoint(3, this.head.method_23317(), this.head.method_23318(), this.head.method_23321());
        for (int i = 0; i < this.tail.size(); ++i) {
            WormSegment segment = this.tail.get(i);
            float delta = (float)i / (float)this.tail.size();
            double l = bezier.length();
            double t = bezier.tForDistance((double)delta * bezier.length());
            class_243 X = bezier.value(t);
            class_243 U = bezier.derivative(t);
            class_241 pitchYaw = NMMaths.rectToPol(U.field_1352, U.field_1351, U.field_1350);
            segment.method_5641(X.field_1352, X.field_1351, X.field_1350, pitchYaw.field_1342, pitchYaw.field_1343);
        }
        this.updateGoalControls();
    }

    protected void method_6023() {
        int i = this.method_37908().method_8503().method_3780() + this.method_5628();
        if (i % 2 == 0 || this.field_6012 <= 1) {
            this.method_37908().method_16107().method_15396("goalSelector");
            this.goalSelector.method_6275();
            this.method_37908().method_16107().method_15407();
        } else {
            this.method_37908().method_16107().method_15396("goalSelector");
            this.goalSelector.method_38849(false);
            this.method_37908().method_16107().method_15407();
        }
    }

    protected void updateGoalControls() {
        this.goalSelector.method_6276(class_1352.class_4134.field_18405, true);
        this.goalSelector.method_6276(class_1352.class_4134.field_18408, true);
    }

    protected class_243 getNeutralHeadPos() {
        return new class_243(this.method_23317(), this.method_23318() + 15.0, this.method_23321());
    }

    private class_241 getNeutralHeadPitch() {
        return new class_241(-90.0f, 0.0f);
    }

    protected void updateHead() {
        this.head.method_5641((Double)this.field_6011.method_12789(HEAD_X), (Double)this.field_6011.method_12789(HEAD_Y), (Double)this.field_6011.method_12789(HEAD_Z), ((Float)this.field_6011.method_12789(HEAD_YAW)).floatValue(), ((Float)this.field_6011.method_12789(HEAD_PITCH)).floatValue());
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.segments.forEach(s -> s.method_5650(reason));
        super.method_5650(reason);
    }

    protected WormActions.Entry chooseAction() {
        return WormActions.random();
    }

    public void setHeadPos(double x, double y, double z) {
        this.field_6011.method_12778(HEAD_X, (Object)x);
        this.field_6011.method_12778(HEAD_Y, (Object)y);
        this.field_6011.method_12778(HEAD_Z, (Object)z);
        this.head.method_23327(x, y, z);
    }

    public void setHeadAngles(float pitch, float yaw) {
        if (!Float.isNaN(pitch)) {
            this.head.method_36457(pitch);
            this.field_6011.method_12778(HEAD_PITCH, (Object)Float.valueOf(pitch));
        }
        if (!Float.isNaN(yaw)) {
            this.head.method_36456(yaw);
            this.field_6011.method_12778(HEAD_YAW, (Object)Float.valueOf(yaw));
        }
    }

    protected PlayState controller(AnimationState<WormEntity> event) {
        return PlayState.CONTINUE;
    }

    @Override
    public Iterable<WormSegment> getParts() {
        return this.segments;
    }

    public void lerpHeadPos(int tick, int totalTicks, class_243 toPos) {
        float delta = (float)tick / (float)totalTicks;
        double headX = class_3532.method_16436((double)delta, (double)this.head.method_23317(), (double)toPos.method_10216());
        double headY = class_3532.method_16436((double)delta, (double)this.head.method_23318(), (double)toPos.method_10214());
        double headZ = class_3532.method_16436((double)delta, (double)this.head.method_23321(), (double)toPos.method_10215());
        this.setHeadPos(headX, headY, headZ);
    }

    public void lerpHeadPos(int tick, int totalTicks, class_243 toPos, Easing.Curve curve) {
        double c = curve.apply((double)tick / (double)totalTicks);
        double headX = this.head.method_23317() + (toPos.method_10216() - this.head.method_23317()) * c;
        double headY = this.head.method_23318() + (toPos.method_10214() - this.head.method_23318()) * c;
        double headZ = this.head.method_23321() + (toPos.method_10215() - this.head.method_23321()) * c;
        this.setHeadPos(headX, headY, headZ);
    }

    public void lerpHeadAngles(int tick, int totalTicks, float toPitch, float toYaw) {
        float delta = (float)tick / (float)totalTicks;
        float headPitch = class_3532.method_16439((float)delta, (float)this.head.method_36455(), (float)toPitch);
        float headYaw = class_3532.method_16439((float)delta, (float)this.head.method_36454(), (float)toYaw);
        this.setHeadAngles(headPitch, headYaw);
    }

    public void returnHeadToNeutral(int tick, int totalTicks) {
        this.lerpHeadPos(tick, totalTicks, this.getNeutralHeadPos());
        class_241 pitchYaw = this.getNeutralHeadPitch();
        this.lerpHeadAngles(tick, totalTicks, pitchYaw.field_1343, pitchYaw.field_1342);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::controller)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }

    public static class WormSegment
    extends class_1297 {
        protected final WormEntity parent;
        protected final class_4048 partDimensions;

        public WormSegment(WormEntity parent, float width, float height) {
            super(parent.method_5864(), parent.method_37908());
            this.parent = parent;
            this.partDimensions = class_4048.method_18384((float)width, (float)height);
            this.method_18382();
        }

        protected void method_5749(class_2487 nbt) {
        }

        protected void method_5652(class_2487 nbt) {
        }

        public void method_36457(float pitch) {
            super.method_36457(pitch);
        }

        public boolean method_5779(class_1297 entity) {
            return this == entity || this.parent == entity;
        }

        public class_2596<class_2602> method_18002() {
            throw new UnsupportedOperationException();
        }

        public void method_31471(class_2604 packet) {
            super.method_31471(packet);
        }

        public class_4048 method_18377(class_4050 pose) {
            return this.partDimensions;
        }

        protected void method_5693() {
        }

        public void method_5641(double x, double y, double z, float yaw, float pitch) {
            this.method_30634(x, y, z);
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
            this.method_36456(yaw);
            this.method_36457(pitch);
        }

        public void method_30634(double x, double y, double z) {
            double d = class_3532.method_15350((double)x, (double)-3.0E7, (double)3.0E7);
            double e = class_3532.method_15350((double)z, (double)-3.0E7, (double)3.0E7);
            this.field_6014 = this.method_23317();
            this.field_6036 = this.method_23318();
            this.field_5969 = this.method_23321();
            this.method_5814(d, y, e);
        }

        public boolean method_5643(class_1282 source, float amount) {
            return this.parent.method_5643(source, amount);
        }

        public boolean method_31746() {
            return false;
        }
    }
}

