/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.implant.entity;

import com.google.common.collect.Multimap;
import com.neep.neepmeat.implant.entity.EntityImplant;
import com.neep.neepmeat.implant.entity.EntityImplantManager;
import com.neep.neepmeat.implant.entity.ImplantRegistry;
import com.neep.neepmeat.init.NMComponents;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobImplantManager
implements EntityImplantManager,
ServerTickingComponent,
AutoSyncedComponent {
    private final Map<class_2960, EntityImplant> installed = new HashMap<class_2960, EntityImplant>();
    private final class_1308 mobEntity;

    public MobImplantManager(class_1308 mobEntity) {
        this.mobEntity = mobEntity;
    }

    @Override
    public boolean installImplant(class_2960 implantId) {
        this.addImplant(implantId);
        NMComponents.IMPLANT_MANAGER.sync((Object)this.mobEntity);
        return true;
    }

    private void addImplant(class_2960 id) {
        ImplantRegistry.Constructor constructor = (ImplantRegistry.Constructor)ImplantRegistry.REGISTRY.method_10223(id);
        if (constructor != null) {
            EntityImplant implant = constructor.create((class_1297)this.mobEntity);
            this.installed.put(id, implant);
            implant.onInstall();
            Multimap<class_1320, class_1322> modifiers = implant.getModifiers();
            if (!modifiers.isEmpty()) {
                this.mobEntity.method_6127().method_26854(modifiers);
            }
            NMComponents.IMPLANT_MANAGER.sync((Object)this.mobEntity);
        }
    }

    @Override
    public boolean removeImplant(class_2960 id) {
        EntityImplant implant = this.installed.remove(id);
        if (implant != null) {
            implant.onUninstall();
            Multimap<class_1320, class_1322> modifiers = implant.getModifiers();
            if (!modifiers.isEmpty()) {
                this.mobEntity.method_6127().method_26847(modifiers);
            }
            NMComponents.IMPLANT_MANAGER.sync((Object)this.mobEntity);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public <T extends EntityImplant> T getImplant(class_2960 id) {
        if (this.installed.isEmpty()) {
            return null;
        }
        return (T)this.installed.get(id);
    }

    @Override
    public Set<class_2960> getInstalled() {
        return this.installed.keySet();
    }

    public void readFromNbt(@NotNull class_2487 nbt) {
        class_2499 list = nbt.method_10554("installed", 8);
        this.installed.clear();
        for (int i = 0; i < list.size(); ++i) {
            class_2960 id = class_2960.method_12829((String)list.method_10608(i));
            this.addImplant(id);
        }
    }

    public void writeToNbt(@NotNull class_2487 nbt) {
        class_2499 list = new class_2499();
        this.installed.forEach((id, implant) -> list.add((Object)class_2519.method_23256((String)id.toString())));
        nbt.method_10566("installed", (class_2520)list);
    }

    public void serverTick() {
        Iterator<EntityImplant> it = this.installed.values().iterator();
        while (it.hasNext()) {
            it.next().tick(it::remove);
        }
    }

    @Override
    public void onDeath() {
        if (!this.mobEntity.method_37908().method_8608()) {
            Iterator<EntityImplant> it = this.installed.values().iterator();
            while (it.hasNext()) {
                it.next().onDeath(it::remove);
            }
        }
    }
}

