/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.implant.entity;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.neep.neepmeat.implant.entity.EntityImplant;
import com.neep.neepmeat.implant.entity.ImplantRenderingHelper;
import com.neep.neepmeat.util.NMMaths;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class SpiderLegsImplant
implements EntityImplant {
    public static final class_2960 ID = new class_2960("neepmeat", "spider_legs");
    public static final class_2960 DEFAULT_MODEL = new class_2960("neepmeat", "default");
    public static final class_2960 TH_0 = new class_2960("neepmeat", "th_0");
    public static final class_2960 TH_1 = new class_2960("neepmeat", "th_1");
    public static final class_2960 BLACK_BOOTS = new class_2960("neepmeat", "black_boots");
    private class_2960 modelId = DEFAULT_MODEL;
    private final List<Leg> legs = new ObjectArrayList();
    private final class_1657 player;
    private double meanFootHeight;
    private double prevMeanFootHeight;
    public float smoothEyeHeight = 1.7f;
    public float prevSmoothEyeHeight = 1.7f;
    private static final Multimap<class_1320, class_1322> MODIFIERS = ImmutableMultimap.builder().put((Object)class_5134.field_23719, (Object)new class_1322("Spider legs modifier", 0.01, class_1322.class_1323.field_6328)).build();

    public SpiderLegsImplant(class_1297 entity) {
        this((class_1657)entity);
    }

    public SpiderLegsImplant(class_1657 player) {
        this.player = player;
        this.meanFootHeight = player.method_23318();
        float step = 0.8f;
        this.legs.add(new Leg(player, 1.0f, step, new class_243(0.3, 0.6, 0.2), new class_243(0.7, 0.0, 0.9)));
        this.legs.add(new Leg(player, 1.0f, step, new class_243(-0.3, 0.6, 0.2), new class_243(-0.7, 0.0, 0.9)));
        this.legs.add(new Leg(player, 1.0f, step, new class_243(-0.4, 0.5, 0.0)));
        this.legs.add(new Leg(player, 1.0f, step, new class_243(0.4, 0.5, 0.0)));
        this.legs.add(new Leg(player, 1.0f, step, new class_243(0.3, 0.6, -0.6)));
        this.legs.add(new Leg(player, 1.0f, step, new class_243(-0.3, 0.6, -0.6)));
    }

    @Override
    public Multimap<class_1320, class_1322> getModifiers() {
        return MODIFIERS;
    }

    public float modifyEyeHeight(class_1657 player) {
        return this.getMeanBodyOffset();
    }

    public boolean swimOrFly() {
        return this.player.method_20232() || this.player.method_6128();
    }

    public float getMeanBodyOffset() {
        return (float)(this.meanFootHeight - this.player.method_23318());
    }

    public double getMeanBodyOffset(float tickDelta) {
        return this.getMeanFootHeight(tickDelta) - class_3532.method_16436((double)tickDelta, (double)this.player.field_6036, (double)this.player.method_23318());
    }

    public double getMeanFootHeight(float tickDelta) {
        return class_3532.method_16436((double)tickDelta, (double)this.prevMeanFootHeight, (double)this.meanFootHeight);
    }

    public void setModelId(class_2960 modelId) {
        this.modelId = modelId;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void tick(Runnable remove) {
        ((ImplantRenderingHelper)this.player).neepmeat$setSpiderLegs(this);
        if (this.player.method_37908().method_8510() % 40L == 0L && this.player.method_49476() < 1.101f) {
            this.player.method_49477(1.101f);
        }
        double meanHeight = 0.0;
        for (Leg leg : this.legs) {
            leg.tick();
            if (!leg.offGround && !this.swimOrFly()) {
                meanHeight += leg.position.field_1351;
                continue;
            }
            meanHeight += this.player.method_23318();
        }
        this.prevMeanFootHeight = this.meanFootHeight;
        class_1937 world = this.player.method_37908();
        double playerY = this.player.method_23318();
        float offset = (float)(meanHeight - playerY);
        this.meanFootHeight = offset > 0.0f && !world.method_8587((class_1297)this.player, this.player.method_24833(class_4050.field_18076).method_997(this.player.method_19538()).method_989(0.0, (double)offset, 0.0)) || this.player.method_5799() ? playerY : (meanHeight /= (double)this.legs.size());
        boolean ascended = this.player.field_6036 < this.player.method_23318();
        this.prevSmoothEyeHeight = this.smoothEyeHeight;
        float target = this.player.method_5751();
        float difference = target - this.smoothEyeHeight;
        float increment = ascended && (double)difference < 0.4 ? difference : difference * 0.5f;
        this.smoothEyeHeight += increment;
    }

    @Override
    public void clientTick() {
        this.tick(() -> {});
    }

    @Override
    public void onInstall() {
        if (this.player.method_49476() < 1.101f) {
            this.player.method_49477(1.101f);
        }
    }

    @Override
    public void onUninstall() {
        ((ImplantRenderingHelper)this.player).neepmeat$setSpiderLegs(null);
        if (this.player.method_49476() == 1.101f) {
            this.player.method_49477(0.6f);
        }
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10582("model_id", this.modelId.toString());
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.modelId = class_2960.method_12829((String)nbt.method_10558("model_id"));
    }

    public List<Leg> getLegs() {
        return this.legs;
    }

    public void onJump() {
        this.legs.forEach(l -> {
            l.offGround = true;
            l.jumpDelayTicks = 7;
        });
    }

    public class_2960 getModelId() {
        return this.modelId;
    }

    public static class Leg {
        private final class_1657 player;
        private class_243 position = class_243.field_1353;
        private class_243 prevPosition0 = class_243.field_1353;
        private class_243 prevPosition1 = class_243.field_1353;
        private final float length;
        private final class_243 offset;
        private final class_243 medianOffset;
        private boolean offGround;
        private int offGroundTicks = 0;
        private int jumpDelayTicks = 0;
        private final float stepRadius;

        public Leg(class_1657 player, float length, float stepRadius, class_243 offset, class_243 medianOffset) {
            this.player = player;
            this.length = length;
            this.offset = offset;
            this.medianOffset = medianOffset;
            this.stepRadius = stepRadius;
            this.position = player.method_19538();
        }

        public Leg(class_1657 player, float length, float stepRadius, class_243 offset) {
            this(player, length, stepRadius, offset, new class_243(offset.field_1352 * 2.0, 0.0, offset.field_1350 * 2.0));
        }

        public class_243 rotatedOffset(float tickDelta) {
            return this.offset.method_1024(-class_3532.method_16439((float)tickDelta, (float)this.player.field_6220, (float)this.player.field_6283) * ((float)Math.PI / 180));
        }

        public class_243 medianOffset(float tickDelta) {
            return this.medianOffset.method_1024(-class_3532.method_16439((float)tickDelta, (float)this.player.field_6220, (float)this.player.field_6283) * ((float)Math.PI / 180));
        }

        public class_243 getPosition() {
            return this.position;
        }

        public class_243 getPositionSmooth(float tickDelta) {
            return this.prevPosition1.method_35590(this.prevPosition0, (double)tickDelta);
        }

        private void moveSwimming(class_1937 world, class_243 median, class_243 currentOrigin) {
            this.offGround = false;
            if (currentOrigin.method_1022(this.position) > (double)(this.segmentLength() * 2.0f)) {
                class_243 to = this.position.method_1020(currentOrigin).method_1029().method_1021((double)(this.segmentLength() * 2.0f));
                this.position = currentOrigin.method_1019(to);
            }
        }

        private void moveWalking(class_1937 world, class_243 median, class_243 currentOrigin) {
            if (NMMaths.distance2D(median.field_1352, median.field_1350, this.position.field_1352, this.position.field_1350) > (double)this.stepRadius || Math.abs(median.field_1351 - this.position.field_1351) > 1.0) {
                class_243 velocity = this.player.method_18798();
                class_243 direction = class_243.field_1353;
                if (velocity.method_1033() > 0.01) {
                    direction = velocity.method_18805(1.0, 0.0, 1.0).method_1029();
                }
                double newX = median.field_1352 + direction.field_1352 * (double)this.stepRadius;
                double newZ = median.field_1350 + direction.field_1350 * (double)this.stepRadius;
                Double ground = this.findGround(world, newX, Math.floor(currentOrigin.field_1351) + 1.0, newZ, 3);
                if (ground != null) {
                    this.position = new class_243(newX, ground.doubleValue(), newZ);
                } else {
                    this.offGround = true;
                }
            }
        }

        public void tick() {
            class_1937 world = this.player.method_37908();
            this.prevPosition1 = this.prevPosition0;
            this.prevPosition0 = this.position;
            class_243 currentOrigin = this.player.method_19538().method_1019(this.rotatedOffset(1.0f));
            class_243 median = this.player.method_19538().method_1019(this.medianOffset(1.0f));
            if (!this.canLand()) {
                this.offGround = true;
            } else if (this.player.method_20232() || this.player.method_6128()) {
                this.moveSwimming(world, median, currentOrigin);
            } else {
                this.moveWalking(world, median, currentOrigin);
            }
            if (this.offGround) {
                Double ground;
                this.position = median.method_1031(0.0, 0.3, 0.0);
                if (this.canLand() && this.offGroundTicks % 5 == 0 && this.jumpDelayTicks == 0 && (ground = this.findGround(world, median.field_1352, Math.floor(currentOrigin.field_1351) + 1.0, median.field_1350, 3)) != null) {
                    this.position = new class_243(median.field_1352, ground.doubleValue(), median.field_1350);
                    this.offGround = false;
                    this.offGroundTicks = 0;
                }
                ++this.offGroundTicks;
                this.jumpDelayTicks = Math.max(0, this.jumpDelayTicks - 1);
            }
        }

        public boolean canLand() {
            return !this.player.method_31549().field_7479 && !this.player.method_6101() && !this.player.method_5765();
        }

        @Nullable
        private Double findGround(class_1937 world, double x, double yStart, double z, int depth) {
            class_3965 result = world.method_17742(new class_3959(new class_243(x, yStart, z), new class_243(x, yStart - (double)depth, z), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.player));
            if (Math.abs(result.method_17784().field_1351 - yStart) < 0.05 && world.method_8320(class_2338.method_49637((double)x, (double)yStart, (double)z)).method_51366() || result.method_17784().field_1351 <= yStart - (double)depth) {
                return null;
            }
            return result.method_17784().field_1351;
        }

        public float segmentLength() {
            return this.length;
        }
    }
}

