/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.item;

import com.neep.meatlib.item.ClientBlockAttackListener;
import com.neep.meatlib.item.TooltipSupplier;
import com.neep.neepmeat.api.item.OverrideSwingItem;
import com.neep.neepmeat.component.CompressedAirComponent;
import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.init.NMSounds;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class RockDrillItem
extends class_1792
implements ClientBlockAttackListener,
OverrideSwingItem {
    public static final class_2960 CHANNEL_ID = new class_2960("rock_drill");
    private final TooltipSupplier tooltipSupplier;

    public RockDrillItem(TooltipSupplier tooltipSupplier, class_1792.class_1793 settings) {
        super(settings.method_7889(1).method_7895(2000));
        this.tooltipSupplier = tooltipSupplier;
    }

    public static boolean using(class_1799 stack) {
        if (stack.method_7909() instanceof RockDrillItem && stack.method_7985()) {
            class_2487 nbt = stack.method_7969();
            return nbt.method_10577("attacking");
        }
        return false;
    }

    private static void onAttackPacket(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        boolean attacking = buf.readBoolean();
        server.execute(() -> {
            class_1799 mainStack = player.method_6047();
            if (mainStack.method_7909() instanceof RockDrillItem) {
                mainStack.method_7948().method_10556("attacking", attacking);
            }
        });
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!world.field_9236) {
            if (state.method_26214((class_1922)world, pos) != 0.0f) {
                stack.method_7956(1, miner, e -> e.method_20235(class_1304.field_6173));
            }
            class_2487 nbt = stack.method_7948();
            long lastTime = nbt.method_10537("last_time");
            long time = world.method_8510();
            if (time - lastTime >= 2L) {
                world.method_43129(null, (class_1297)miner, NMSounds.ROCK_DRILL, class_3419.field_15248, (float)miner.method_6051().method_43385(1.0, 0.1), (float)miner.method_6051().method_43385(1.0, 0.04));
                nbt.method_10544("last_time", time);
            }
        }
        return true;
    }

    private void sendAttack(boolean attacking) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(attacking);
        ClientPlayNetworking.send((class_2960)CHANNEL_ID, (class_2540)buf);
    }

    public boolean method_7856(class_2680 state) {
        return state.method_26164(NMTags.ROCK_DRILL_MINEABLE);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        if (state.method_26164(NMTags.ROCK_DRILL_MINEABLE)) {
            return 50.0f;
        }
        return super.method_7865(stack, state);
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        CompressedAirComponent component = (CompressedAirComponent)NMComponents.COMPRESSED_AIR.getNullable((Object)miner);
        if (component != null && component.getAir() > 0L) {
            return state.method_26164(NMTags.ROCK_DRILL_MINEABLE);
        }
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        this.tooltipSupplier.apply(this, tooltip);
        super.method_7851(stack, world, tooltip, context);
    }

    @Override
    public void onAttackBlock(class_1799 stack, class_1657 player) {
        this.sendAttack(true);
    }

    @Override
    public void onFinishAttackBlock(class_1799 stack, class_1657 player) {
        this.sendAttack(false);
    }

    static {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL_ID, RockDrillItem::onAttackPacket);
    }
}

