/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.item;

import com.neep.meatlib.item.BaseSwordItem;
import com.neep.meatlib.item.TooltipSupplier;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.meatweapons.Util;
import com.neep.meatweapons.item.WeakTwoHanded;
import com.neep.neepmeat.api.item.OverrideSwingItem;
import com.neep.neepmeat.init.NMBlocks;
import com.neep.neepmeat.init.NMCriteria;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.init.NMItems;
import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.recipe.VivisectionRecipe;
import com.neep.neepmeat.transport.block.fluid_transport.entity.FluidDrainBlockEntity;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public class TissueOperatorItem
extends BaseSwordItem
implements OverrideSwingItem,
WeakTwoHanded {
    private final TooltipSupplier tooltipSupplier = TooltipSupplier.hidden(1);

    public TissueOperatorItem(RegistrationContext ctx, class_1792.class_1793 settings) {
        super((class_1832)class_1834.field_8930, 3, -2.4f, settings);
    }

    public static void spawnBloodParticles(class_243 entityPos, class_3218 world) {
        world.method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10541.method_9564()), entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, 30, 0.1, 1.0, 0.1, 0.1);
    }

    public static boolean tryRecipe(class_1937 world, class_243 pos, class_1309 entity, boolean client) {
        VivisectionRecipe.VivisectionContext ctx = new VivisectionRecipe.VivisectionContext(world, entity);
        VivisectionRecipe recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.VIVISECTION, ctx).orElse(null);
        if (recipe != null) {
            recipe.ejectOutputs(ctx, (TransactionContext)null);
            world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, NMSounds.VIVISECTION_COMPLETE, class_3419.field_15248, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean displayArmFirstPerson(class_1799 stack, class_1268 hand) {
        return false;
    }

    @Override
    public WeakTwoHanded.ArmPose getThirdPersonArmPose(class_742 player, class_1799 stackInHand, class_1268 hand) {
        return WeakTwoHanded.ArmPose.BOW_AND_ARROW;
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    @Override
    public boolean onSwing(class_1799 stack, class_1657 player) {
        player.field_6251 = 0.0f;
        player.field_6279 = 0;
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        this.tooltipSupplier.apply((class_1792)this, tooltip);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_2338 pos;
        class_2586 class_25862;
        super.method_7873(stack, target, attacker);
        class_1937 world = target.method_5770();
        if (!world.method_8608() && (class_25862 = world.method_8321((pos = target.method_24515()).method_10074())) instanceof FluidDrainBlockEntity) {
            FluidDrainBlockEntity be = (FluidDrainBlockEntity)class_25862;
            class_243 soundPos = target.method_19538();
            world.method_43128(null, soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, NMSounds.SCALPEL_HIT, class_3419.field_15248, 1.0f, 1.0f);
            if (target.method_29504()) {
                try (Transaction transaction = Transaction.openOuter();){
                    be.getBuffer(class_2350.field_11036).insert(FluidVariant.of((class_3611)NMFluids.STILL_BLOOD), 20250L, (TransactionContext)transaction);
                    transaction.commit();
                }
            }
        }
        TissueOperatorItem.spawnBloodParticles(target.method_19538(), (class_3218)world);
        return true;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (state.method_27852(NMBlocks.INTEGRATOR_EGG)) {
            // empty if block
        }
        return super.method_7879(stack, world, state, pos, miner);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (world.method_8608() && remainingUseTicks % 10 == 0) {
            user.method_5783(class_3417.field_14975, 1.0f, (float)world.method_8409().method_43385(1.0, (double)0.6f));
            user.method_5783(class_3417.field_29543, 1.0f, 1.0f);
        }
    }

    public int method_7881(class_1799 stack) {
        return 40;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (!world.method_8608()) {
                Optional<class_1309> optional = this.getEntity(player);
                class_2338 pos = this.getBlock(player);
                if (optional.isPresent()) {
                    class_1309 entity = optional.get();
                    entity.method_5643(world.method_48963().method_48802(player), 10.0f);
                    class_243 entityPos = entity.method_19538();
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        serverWorld.method_14199((class_2394)NMParticles.BLOOD_SHOWER, entityPos.field_1352, entityPos.field_1351 + (double)(entity.method_17682() / 2.0f), entityPos.field_1350, 20, 0.05, 0.05, 0.05, 0.1);
                    }
                    if (TissueOperatorItem.tryRecipe(world, entity.method_19538(), entity, world.method_8608()) && player instanceof class_3222) {
                        class_3222 serverPlayerEntity = (class_3222)player;
                        NMCriteria.VIVISECTION.trigger(serverPlayerEntity, (class_1297)entity);
                    }
                    this.method_7873(stack, entity, (class_1309)player);
                } else if (pos != null && world.method_8320(pos).method_27852(NMBlocks.INTEGRATOR_EGG)) {
                    world.method_22352(pos, false);
                    class_1799 stack1 = NMItems.CHRYSALIS.method_7854();
                    class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack1);
                    world.method_8649((class_1297)itemEntity);
                    world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), NMSounds.VIVISECTION_COMPLETE, class_3419.field_15248, 1.0f, 1.0f);
                }
                return stack;
            }
        }
        return super.method_7861(stack, world, user);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (this.getEntity(user).isPresent() || this.getBlock(user) != null) {
            user.method_6019(hand);
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        super.method_7840(stack, world, user, remainingUseTicks);
    }

    protected Optional<class_1309> getEntity(class_1657 user) {
        class_243 pos = user.method_33571();
        class_243 end = pos.method_1019(user.method_5828(0.5f).method_1021(20.0));
        return this.getTarget(user, user.method_33571(), end, 4.0);
    }

    public Optional<class_1309> getTarget(class_1657 caster, class_243 start, class_243 end, double distance) {
        class_1937 world = caster.method_37908();
        if (!world.field_9236) {
            class_3959 ctx = new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)caster);
            class_3965 blockResult = world.method_17742(ctx);
            Predicate<class_1297> entityFilter = entity -> !entity.method_7325() && entity.method_5863() && entity instanceof class_1309;
            double minDistance = distance;
            class_1297 entity2 = null;
            for (class_3966 result : Util.getRayTargets((class_1309)caster, start, blockResult.method_17784(), entityFilter, 0.1)) {
                if (!(result.method_17784().method_1022(start) < minDistance)) continue;
                minDistance = result.method_17784().method_1022(start);
                entity2 = result.method_17782();
            }
            return Optional.ofNullable((class_1309)entity2);
        }
        return Optional.empty();
    }

    @Nullable
    protected class_2338 getBlock(class_1657 user) {
        class_243 pos = user.method_33571();
        class_243 end = pos.method_1019(user.method_5828(0.5f).method_1021(4.0));
        return this.getBlockTarget(pos, end, user.method_37908(), (class_1297)user);
    }

    @Nullable
    protected class_2338 getBlockTarget(class_243 start, class_243 end, class_1937 world, class_1297 entity) {
        class_3959 context = new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity);
        class_3965 result = world.method_17742(context);
        if (result.method_17783() != class_239.class_240.field_1333 && world.method_8320(result.method_17777()).method_27852(NMBlocks.INTEGRATOR_EGG)) {
            return result.method_17777();
        }
        return null;
    }
}

