/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.charnel_compactor;

import com.google.common.collect.MapMaker;
import com.neep.neepmeat.init.NMItems;
import com.neep.neepmeat.machine.charnel_compactor.CharnelCompactorBlock;
import com.neep.neepmeat.machine.integrator.Integrator;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ExtractionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class CharnelCompactorStorage
extends SnapshotParticipant<Float> {
    private static final Map<WorldLocation, CharnelCompactorStorage> CHARNEL_STORAGES = new MapMaker().concurrencyLevel(1).weakValues().makeMap();
    private static final ItemVariant OUTPUT = ItemVariant.of((class_1935)NMItems.CRUDE_INTEGRATION_CHARGE);
    private static final float DO_NOTHING = 0.0f;
    private static final float EXTRACT_OUTPUT = -1.0f;
    private final WorldLocation location;
    private final TopStorage upStorage = new TopStorage();
    private final BottomStorage downStorage = new BottomStorage();
    private Float increaseProbability = Float.valueOf(0.0f);

    private CharnelCompactorStorage(WorldLocation location) {
        this.location = location;
    }

    @Nullable
    public static Storage<ItemVariant> getStorage(class_1937 world, class_2338 pos, class_2350 direction) {
        Objects.requireNonNull(direction);
        WorldLocation location = new WorldLocation(world, pos.method_10062());
        CharnelCompactorStorage storage = CHARNEL_STORAGES.computeIfAbsent(location, CharnelCompactorStorage::new);
        if (direction == class_2350.field_11036) {
            return storage.upStorage;
        }
        return storage.downStorage;
    }

    public static void extractOutput(WorldLocation location, boolean spawnItem) {
        location.setBlockState((class_2680)location.getBlockState().method_11657((class_2769)CharnelCompactorBlock.LEVEL, (Comparable)Integer.valueOf(0)));
        class_1937 world = location.world;
        class_2338 pos = location.pos;
        if (spawnItem) {
            double d = world.field_9229.method_43057() * 0.7f + 0.15f;
            double e = (double)(world.field_9229.method_43057() * 0.7f) + 0.06000000238418579 + 0.6;
            double g = world.field_9229.method_43057() * 0.7f + 0.15f;
            class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + d, (double)pos.method_10264() + e, (double)pos.method_10260() + g, OUTPUT.toStack(1));
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
            world.method_8396(null, pos, class_3417.field_17606, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public static void addLevel(WorldLocation location) {
        class_2680 state = location.getBlockState();
        int newLevel = Math.min(7, (Integer)state.method_11654((class_2769)CharnelCompactorBlock.LEVEL) + 3);
        class_2680 newState = (class_2680)state.method_11657((class_2769)CharnelCompactorBlock.LEVEL, (Comparable)Integer.valueOf(newLevel));
        location.setBlockState(newState);
        if (newLevel == 7) {
            location.world.method_39279(location.pos, state.method_26204(), 20);
        }
    }

    protected Float createSnapshot() {
        return this.increaseProbability;
    }

    protected void readSnapshot(Float snapshot) {
        this.increaseProbability = snapshot;
    }

    protected void onFinalCommit() {
        if (this.increaseProbability.floatValue() == -1.0f) {
            CharnelCompactorStorage.extractOutput(this.location, false);
        } else if (this.increaseProbability.floatValue() > 0.0f) {
            boolean increaseSuccessful;
            boolean bl = increaseSuccessful = this.location.world.method_8409().method_43058() < (double)this.increaseProbability.floatValue();
            if (increaseSuccessful) {
                CharnelCompactorStorage.addLevel(this.location);
            }
        }
        this.increaseProbability = Float.valueOf(0.0f);
    }

    private class TopStorage
    implements InsertionOnlyStorage<ItemVariant> {
        private TopStorage() {
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            if (maxAmount < 1L) {
                return 0L;
            }
            Integrator integrator = Integrator.findIntegrator(CharnelCompactorStorage.this.location.world(), CharnelCompactorStorage.this.location.pos(), 10);
            if (CharnelCompactorStorage.this.increaseProbability.floatValue() != 0.0f || integrator == null || !integrator.canEnlighten()) {
                return 0L;
            }
            if ((Integer)CharnelCompactorStorage.this.location.getBlockState().method_11654((class_2769)CharnelCompactorBlock.LEVEL) >= 7) {
                return 0L;
            }
            float insertedIncreaseProbability = CharnelCompactorBlock.getIncreaseChance(resource.getItem());
            if (insertedIncreaseProbability <= 0.0f) {
                return 0L;
            }
            CharnelCompactorStorage.this.updateSnapshots(transaction);
            CharnelCompactorStorage.this.increaseProbability = Float.valueOf(insertedIncreaseProbability);
            return 1L;
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            return Collections.emptyIterator();
        }
    }

    private class BottomStorage
    implements ExtractionOnlyStorage<ItemVariant>,
    SingleSlotStorage<ItemVariant> {
        private BottomStorage() {
        }

        private boolean hasOutput() {
            return CharnelCompactorStorage.this.increaseProbability.floatValue() == 0.0f && (Integer)CharnelCompactorStorage.this.location.getBlockState().method_11654((class_2769)CharnelCompactorBlock.LEVEL) == 8;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            if (maxAmount < 1L) {
                return 0L;
            }
            if (!OUTPUT.equals(resource)) {
                return 0L;
            }
            if (!this.hasOutput()) {
                return 0L;
            }
            CharnelCompactorStorage.this.updateSnapshots(transaction);
            CharnelCompactorStorage.this.increaseProbability = Float.valueOf(-1.0f);
            return 1L;
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public ItemVariant getResource() {
            return OUTPUT;
        }

        public long getAmount() {
            return this.hasOutput() ? 1L : 0L;
        }

        public long getCapacity() {
            return 1L;
        }
    }

    public record WorldLocation(class_1937 world, class_2338 pos) {
        private class_2680 getBlockState() {
            return this.world.method_8320(this.pos);
        }

        private void setBlockState(class_2680 state) {
            this.world.method_8501(this.pos, state);
        }
    }
}

