/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.charnel_pump;

import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.machine.charnel_pump.CharnelPumpBlockEntity;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Vector3f;

public class CharnelPumpRenderer
implements class_827<CharnelPumpBlockEntity> {
    public CharnelPumpRenderer(class_5614.class_5615 context) {
    }

    public static float plungerAnimation(CharnelPumpBlockEntity be, float t) {
        float s = CharnelPumpBlockEntity.isRising(t) ? CharnelPumpRenderer.easeInOutSine(t / 60.0f) : 1.0f - (t - 60.0f) / 40.0f;
        return s;
    }

    public static float easeInOutSine(float x) {
        return (float)(-(Math.cos(Math.PI * (double)x) - 1.0) / 2.0);
    }

    public void render(CharnelPumpBlockEntity be, float tickDelta, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        FluidVariant fluidVariant;
        class_1058 sprite;
        int upLight = class_761.method_23794((class_1920)be.method_10997(), (class_2338)be.method_11016().method_10086(1));
        float t = be.animationTicks > 0.0f ? 100.0f - be.animationTicks + tickDelta * be.progressIncrement() : 0.0f;
        float height = 0.0f;
        if (be.hasFluidCurrentCycle) {
            height = 3.0f * CharnelPumpRenderer.plungerAnimation(be, t) + 0.25f;
        }
        if ((sprite = FluidVariantRendering.getSprite((FluidVariant)(fluidVariant = FluidVariant.of((class_3611)NMFluids.STILL_WORK_FLUID)))) == null) {
            return;
        }
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        assert (renderer != null);
        QuadEmitter emitter = renderer.meshBuilder().getEmitter();
        class_4588 consumer = vcp.getBuffer(class_4696.method_23683((class_2680)class_2246.field_9997.method_9564(), (boolean)false));
        matrices.method_46416(0.0f, 3.0f, 0.0f);
        matrices.method_22904(0.5, 0.0, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
        CharnelPumpRenderer.renderFluidColumn(height, 0.9f, matrices, sprite, emitter, consumer, upLight);
    }

    private static void renderFluidColumn(float height, float radius, class_4587 matrices, class_1058 sprite, QuadEmitter emitter, class_4588 consumer, int light) {
        float u0 = sprite.method_4594();
        float u1 = sprite.method_4577();
        float v0 = sprite.method_4593();
        float v1 = sprite.method_4575();
        float k = 0.0f;
        float m = 0.0f;
        float l = radius;
        float g = height;
        float cr = 1.0f;
        float cg = 1.0f;
        float cb = 1.0f;
        for (int seg = 1; seg <= 8; ++seg) {
            float o = class_3532.method_15374((float)((float)(seg * 2) * (float)Math.PI / 8.0f)) * radius;
            float p = class_3532.method_15362((float)((float)(seg * 2) * (float)Math.PI / 8.0f)) * radius;
            float q = (float)seg / 8.0f;
            emitter.pos(0, new Vector3f(k, l, 0.0f)).uv(0, u1, v0);
            emitter.pos(1, new Vector3f(k, l, g)).uv(1, u0, v0);
            emitter.pos(2, new Vector3f(o, p, g)).uv(2, u0, v1);
            emitter.pos(3, new Vector3f(o, p, 0.0f)).uv(3, u1, v1);
            class_777 quad = emitter.toBakedQuad(sprite);
            consumer.method_22919(matrices.method_23760(), quad, cr, cg, cb, light, class_4608.field_21444);
            k = o;
            l = p;
        }
    }
}

