/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine;

import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.machine.live_machine.process.CharnelPumpProcess;
import com.neep.neepmeat.machine.live_machine.process.CrusherProcess;
import com.neep.neepmeat.machine.live_machine.process.DisruptorProcess;
import com.neep.neepmeat.machine.live_machine.process.DistributorPointProcess;
import com.neep.neepmeat.machine.live_machine.process.LargeCompressorProcess;
import com.neep.neepmeat.machine.live_machine.process.LargeTrommelProcess;
import com.neep.neepmeat.machine.live_machine.process.MetaboliserProcess;
import com.neep.neepmeat.machine.live_machine.process.PhageRayProcess;
import com.neep.neepmeat.machine.live_machine.process.TreeVacuumProcess;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Processes {
    private static final Processes INSTANCE = new Processes();
    private final List<Pair<BitSet, Process>> entries = new ObjectArrayList();

    public static Processes getInstance() {
        return INSTANCE;
    }

    public List<Pair<BitSet, Process>> getEntries() {
        return this.entries;
    }

    public void register(Process process) {
        this.register(process, process.getRequired().toArray(new ComponentType[0]));
    }

    public void register(BitSet bitSet, Process process) {
        this.entries.add((Pair<BitSet, Process>)Pair.of((Object)bitSet, (Object)process));
    }

    public void register(Process process, ComponentType<?> ... types) {
        BitSet bitSet = new BitSet();
        for (ComponentType<?> type : types) {
            bitSet.set(type.getBitIdx());
        }
        this.register(bitSet, process);
    }

    @Nullable
    public Process getFirstMatch(BitSet bits) {
        for (Pair<BitSet, Process> pair : this.entries) {
            BitSet copy = (BitSet)((BitSet)pair.key()).clone();
            copy.and(bits);
            if (copy.cardinality() != ((BitSet)pair.key()).cardinality()) continue;
            return (Process)pair.value();
        }
        return null;
    }

    public static void init() {
        Processes.getInstance().register(new CrusherProcess());
        Processes.getInstance().register(new PhageRayProcess());
        Processes.getInstance().register(new LargeTrommelProcess());
        Processes.getInstance().register(new TreeVacuumProcess());
        Processes.getInstance().register(new CharnelPumpProcess());
        Processes.getInstance().register(new LargeCompressorProcess());
        Processes.getInstance().register(new DisruptorProcess());
        Processes.getInstance().register(new MetaboliserProcess());
        Processes.getInstance().register(new DistributorPointProcess());
    }
}

