/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineComponent;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.grinder.CrusherRecipeContext;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.component.PoweredComponent;
import com.neep.neepmeat.recipe.CrushingRecipe;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class CrusherSegmentBlockEntity
extends SyncableBlockEntity
implements LivingMachineComponent,
PoweredComponent {
    private final InputSlot slot = new InputSlot(this::sync);
    private float progressIncrement;
    private float maxIncrement;
    private final Random jrandom = new Random();

    public CrusherSegmentBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("progress_increment", this.progressIncrement);
        this.slot.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.progressIncrement = nbt.method_10583("progress_increment");
        this.slot.readNbt(nbt);
    }

    @Override
    public boolean componentRemoved() {
        return this.method_11015();
    }

    public ComponentType<?> getComponentType() {
        return LivingMachineComponents.CRUSHER_SEGMENT;
    }

    public InputSlot getStorage() {
        return this.slot;
    }

    @Override
    public float progressIncrement() {
        return this.progressIncrement;
    }

    @Override
    public void setProgressIncrement(float progressIncrement) {
        if (progressIncrement != this.progressIncrement) {
            this.progressIncrement = progressIncrement;
            this.sync();
        }
    }

    public float minIncrement() {
        return 0.0f;
    }

    public void clientTick() {
        float intensity = this.progressIncrement / 2.0f;
        int tickInterval = (int)class_3532.method_15363((float)1.0f, (float)(1.0f / (intensity * 2.0f)), (float)100.0f);
        if (this.field_11863.method_8510() % (long)tickInterval == 0L && this.progressIncrement() >= this.minIncrement()) {
            double pz;
            double px;
            if (this.slot.isEmpty() || this.slot.getRecipe() == null) {
                return;
            }
            if (this.jrandom.nextBoolean()) {
                px = (double)this.field_11867.method_10263() + 0.5 + (this.jrandom.nextBoolean() ? -1.5 : 1.5);
                pz = (double)this.method_11016().method_10260() + 0.5 + ((double)this.jrandom.nextFloat() - 0.5) * 3.0;
            } else {
                pz = (double)this.field_11867.method_10260() + 0.5 + (this.jrandom.nextBoolean() ? -1.5 : 1.5);
                px = (double)this.method_11016().method_10263() + 0.5 + ((double)this.jrandom.nextFloat() - 0.5) * 3.0;
            }
            double py = (double)this.method_11016().method_10264() + 0.5 + ((double)this.jrandom.nextFloat() - 0.5) * 0.5;
            double vx = ((double)this.jrandom.nextFloat() - 0.5) * 0.4;
            double vy = (double)this.jrandom.nextFloat() * 0.3;
            double vz = ((double)this.jrandom.nextFloat() - 0.5) * 0.4;
            this.field_11863.method_8406((class_2394)new class_2392(class_2398.field_11218, this.slot.getAsStack()), px, py, pz, vx, vy, vz);
        }
    }

    public static class InputSlot
    extends WritableStackStorage {
        @Nullable
        private CrushingRecipe recipe;
        private float progress;

        public InputSlot(@Nullable Runnable parent) {
            super(parent);
        }

        public void tick(float progressIncrement, Storage<ItemVariant> output, float chanceMod, TransactionContext transaction) {
            SimpleCrushingStorage storage = new SimpleCrushingStorage((Storage<ItemVariant>)this, output, chanceMod);
            if (this.recipe != null) {
                this.progress += progressIncrement;
                if (this.progress >= (float)this.recipe.getTime()) {
                    if (this.recipe.ejectOutputs(storage, transaction)) {
                        this.recipe.takeInputs(storage, transaction);
                    }
                    this.recipe = null;
                    this.progress = 0.0f;
                    this.syncIfPossible();
                }
            } else if (!this.isEmpty()) {
                CrushingRecipe foundRecipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.ADVANCED_CRUSHING, storage).orElse(null);
                if (foundRecipe == null) {
                    foundRecipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.GRINDING, storage).orElse(null);
                }
                if (foundRecipe != null) {
                    this.recipe = foundRecipe;
                } else if (!this.isEmpty()) {
                    this.recipe = MeatlibRecipes.getInstance().get(NMrecipeTypes.ADVANCED_CRUSHING, new class_2960("neepmeat", "advanced_crushing/destroy")).orElse(null);
                }
                this.syncIfPossible();
            }
        }

        public long getCapacity() {
            return 1L;
        }

        @Override
        protected long getCapacity(ItemVariant variant) {
            return 1L;
        }

        @Override
        public void writeNbt(class_2487 nbt) {
            if (this.recipe != null) {
                nbt.method_10582("recipe", this.recipe.method_8114().toString());
            }
            super.writeNbt(nbt);
        }

        @Override
        public void readNbt(class_2487 nbt) {
            super.readNbt(nbt);
            this.recipe = nbt.method_10545("recipe") ? (CrushingRecipe)MeatlibRecipes.getInstance().get(class_2960.method_12829((String)nbt.method_10558("recipe"))).orElse(null) : null;
        }

        @Nullable
        public CrushingRecipe getRecipe() {
            return this.recipe;
        }
    }

    public static class SimpleCrushingStorage
    implements CrusherRecipeContext {
        private final Storage<ItemVariant> input;
        private final Storage<ItemVariant> output;
        private final CrusherRecipeContext.XpStorage xpStorage = new CrusherRecipeContext.XpStorage();
        private final float chanceMod;

        public SimpleCrushingStorage(Storage<ItemVariant> input, Storage<ItemVariant> output, float chanceMod) {
            this.input = input;
            this.output = output;
            this.chanceMod = chanceMod;
        }

        @Override
        public Storage<ItemVariant> getInputStorage() {
            return this.input;
        }

        @Override
        public Storage<ItemVariant> getOutputStorage() {
            return this.output;
        }

        @Override
        public Storage<ItemVariant> getExtraStorage() {
            return this.output;
        }

        @Override
        public CrusherRecipeContext.XpStorage getXpStorage() {
            return this.xpStorage;
        }

        @Override
        public float getChanceMod() {
            return this.chanceMod;
        }
    }
}

