/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.reactor;

import com.neep.neepmeat.machine.reactor.block.entity.CoreSensorBlockEntity;
import net.minecraft.class_3532;

public class ReactionCoreParameters {
    private boolean dead;
    private double organisation = 0.0;
    private double organisationFlow = 0.0;
    private double incidentZoneRadius = 0.0;
    private double exudateMassFlow = 0.0;
    private double storedExudate = 0.0;
    private double cudEfficiency = 0.0;

    public void tick(float disruption, float maxOrganisation, float maxOrganisationIncrease, int dt) {
        float km = 4.0E-4f;
        float ke = 1.0f;
        this.organisationFlow = Math.min((double)(maxOrganisationIncrease * (float)dt), (double)maxOrganisation - this.organisation);
        this.organisation = class_3532.method_15350((double)(this.organisation + this.organisationFlow), (double)0.0, (double)maxOrganisation);
        this.organisationFlow = Math.min((double)(maxOrganisationIncrease * 5.0f), (double)maxOrganisation - this.organisation);
        this.organisation = class_3532.method_15350((double)(this.organisation - (double)(disruption * (float)dt)), (double)0.0, (double)maxOrganisation);
        this.exudateMassFlow = (double)km * this.organisation;
        this.storedExudate += this.exudateMassFlow;
        this.cudEfficiency = maxOrganisation == 0.0f ? 0.0 : (double)ke * class_3532.method_15350((double)this.organisationFlow, (double)0.0, (double)maxOrganisation) / (double)maxOrganisation;
        if (this.organisation == 0.0) {
            this.dead = true;
        }
    }

    public void tickIncidentZone() {
        float k1 = 0.03f;
        float k2 = 0.1f;
        this.incidentZoneRadius = (double)k1 * this.storedExudate + (double)k2 * this.exudateMassFlow;
    }

    public void emitSensorData(CoreSensorBlockEntity sensor) {
        sensor.organisation.send(this.organisation);
        sensor.incidentZoneRadius.send(this.incidentZoneRadius);
        sensor.exudateFlow.send(this.exudateMassFlow * 200.0);
        sensor.storedExudate.send(this.storedExudate * 10.0);
        sensor.cudEfficiency.send(this.cudEfficiency * 100.0);
    }

    public double getIncidentZoneRadius() {
        return this.incidentZoneRadius;
    }

    public double getCudEfficiency() {
        return this.cudEfficiency;
    }

    public double getStoredExudate() {
        return this.storedExudate;
    }

    public void extractStored(double toExtract) {
        this.storedExudate -= toExtract;
    }

    public boolean isDead() {
        return this.dead;
    }
}

