/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.small_trommel;

import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.machine.small_trommel.SmallTrommelBlockEntity;
import com.neep.neepmeat.machine.small_trommel.TrommelStorage;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class SmallTrommelStorage
implements TrommelStorage,
NbtSerialisable {
    protected final LazyBlockApiCache<Storage<FluidVariant>, class_2350> fluidInput;
    protected final WritableSingleFluidStorage fluidOutput;
    protected final WritableStackStorage itemOutput;
    protected SmallTrommelBlockEntity parent;
    public static final SingleVariantStorage<FluidVariant> SINGLE_EMPTY = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 0L;
        }
    };

    public SmallTrommelStorage(SmallTrommelBlockEntity parent) {
        this.parent = parent;
        this.fluidInput = LazyBlockApiCache.of(FluidStorage.SIDED, parent.method_11016().method_10084(), () -> ((SmallTrommelBlockEntity)parent).method_10997(), () -> class_2350.field_11033);
        this.fluidOutput = new WritableSingleFluidStorage(81000L, parent::method_5431);
        this.itemOutput = new WritableStackStorage(parent::method_5431, 16);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        class_2487 outputNbt = new class_2487();
        this.fluidOutput.toNbt(outputNbt);
        nbt.method_10566("fluidOutput", (class_2520)outputNbt);
        class_2487 itemOutputNbt = new class_2487();
        this.itemOutput.writeNbt(itemOutputNbt);
        nbt.method_10566("itemOutput", (class_2520)itemOutputNbt);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.fluidOutput.readNbt((class_2487)Objects.requireNonNull(nbt.method_10580("fluidOutput")));
        this.itemOutput.readNbt((class_2487)Objects.requireNonNull(nbt.method_10580("itemOutput")));
    }

    @Override
    public SingleVariantStorage<FluidVariant> input() {
        Storage<FluidVariant> storage = this.fluidInput.find();
        if (storage instanceof SingleVariantStorage) {
            SingleVariantStorage singleVariantStorage = (SingleVariantStorage)storage;
            return singleVariantStorage;
        }
        return SINGLE_EMPTY;
    }

    public WritableSingleFluidStorage output() {
        return this.fluidOutput;
    }

    public WritableStackStorage itemOutput() {
        return this.itemOutput;
    }
}

