/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.synthesiser;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.entity.MobEggEntity;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.init.NMItems;
import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.machine.synthesiser.MobSynthesisRegistry;
import com.neep.neepmeat.machine.synthesiser.SynthesiserBlock;
import com.neep.neepmeat.machine.synthesiser.SynthesiserStorage;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class SynthesiserBlockEntity
extends SyncableBlockEntity {
    public static final float MAX_DISPLACEMENT = -0.5625f;
    public static final float MIN_DISPLACEMENT = 0.0f;
    public float clientDisplacement;
    protected State state = State.IDLE;
    protected float progress;
    protected int maxProgress;
    protected float increment = 1.0f;
    protected long requiredAmount;
    protected Random random;
    protected SynthesiserStorage storage = new SynthesiserStorage(this);

    public SynthesiserBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.random = new Random(pos.method_10063());
    }

    public SynthesiserBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.SYNTHESISER, pos, state);
    }

    @Nullable
    protected class_1299<?> getEntityType() {
        return this.storage.getEntityType();
    }

    public void tick() {
        if (this.state == State.IDLE) {
            MobSynthesisRegistry.Entry entry;
            class_1299<?> type = this.getEntityType();
            if (type != null && (entry = MobSynthesisRegistry.get(type)) != null) {
                this.progress = 0.0f;
                this.maxProgress = entry.time();
                this.state = State.RUNNING;
                this.requiredAmount = entry.meat();
            }
        } else if (this.state == State.RUNNING) {
            float prevProgress = this.progress;
            this.progress = Math.min((float)this.maxProgress, this.progress + this.increment);
            if (this.progress >= (float)this.maxProgress && !this.redstonePowered() && this.createEntity()) {
                this.progress = 0.0f;
                this.state = State.IDLE;
            }
            if (prevProgress != this.progress) {
                this.sync();
            }
        }
    }

    public boolean redstonePowered() {
        return (Boolean)this.method_11010().method_11654((class_2769)SynthesiserBlock.POWERED);
    }

    protected boolean createEntity() {
        try (Transaction transaction = Transaction.openOuter();){
            MobSynthesisRegistry.Entry entry = MobSynthesisRegistry.get(this.getEntityType());
            if (entry == null) {
                boolean bl = false;
                return bl;
            }
            long extracted = this.storage.meatStorage.extract((TransferVariant)FluidVariant.of((class_3611)NMFluids.STILL_MEAT), entry.meat(), (TransactionContext)transaction);
            class_243 entityPos = SynthesiserBlockEntity.getEntityPos(this.field_11867);
            if (extracted == entry.meat()) {
                MobEggEntity entity = new MobEggEntity(this.field_11863, this.getEntityType());
                entity.method_23327(entityPos.field_1352, entityPos.field_1351, entityPos.field_1350);
                entity.method_18800(((double)this.random.nextFloat() - 0.5) * 0.1, -0.2, ((double)this.random.nextFloat() - 0.5) * 0.1);
                this.field_11863.method_8649((class_1297)entity);
                ((class_3218)this.field_11863).method_14199((class_2394)NMParticles.BLOOD_SHOWER, entityPos.field_1352, (double)this.field_11867.method_10264(), entityPos.field_1350, 50, 0.5, 0.0, 0.5, 0.02);
                ((class_3218)this.field_11863).method_14199((class_2394)NMParticles.BODY_COMPOUND_SHOWER, entityPos.field_1352, (double)this.field_11867.method_10264(), entityPos.field_1350, 50, 0.5, 0.3, 0.5, 0.02);
                transaction.commit();
                boolean bl = true;
                return bl;
            }
            transaction.abort();
        }
        return false;
    }

    protected static class_243 getEntityPos(class_2338 pos) {
        return new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() - 1.1, (double)pos.method_10260() + 0.5);
    }

    public float getClientDisplacement() {
        float delta = Math.min(this.progress / (float)this.maxProgress, (float)this.storage.meatStorage.getAmount() / (float)this.requiredAmount);
        return this.maxProgress != 0 ? class_3532.method_16439((float)delta, (float)-0.5625f, (float)0.0f) : -0.5625f;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("progress", this.progress);
        nbt.method_10569("maxProgress", this.maxProgress);
        nbt.method_10548("increment", this.increment);
        nbt.method_10569("state", this.state.ordinal());
        nbt.method_10544("requiredAmount", this.requiredAmount);
        this.storage.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.progress = nbt.method_10583("progress");
        this.maxProgress = nbt.method_10550("maxProgress");
        this.increment = nbt.method_10583("increment");
        this.state = State.values()[nbt.method_10550("state")];
        this.requiredAmount = nbt.method_10537("requiredAmount");
        this.storage.readNbt(nbt);
    }

    public Storage<ItemVariant> getItemStorage(class_2350 ignore) {
        return this.storage.itemStorage;
    }

    public boolean changeEntityType(class_1657 player, class_1799 heldStack) {
        Transaction transaction;
        if (!this.storage.itemStorage.isEmpty()) {
            transaction = Transaction.openOuter();
            try {
                class_1799 stack = this.storage.itemStorage.getAsStack();
                boolean success = player.method_7270(stack);
                if (!success) {
                    transaction.abort();
                    boolean bl = false;
                    return bl;
                }
                this.storage.itemStorage.extract((TransferVariant)((ItemVariant)this.storage.itemStorage.variant), this.storage.itemStorage.amount, (TransactionContext)transaction);
                transaction.commit();
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        if (heldStack.method_31574(NMItems.ESSENTIAL_SALTES)) {
            transaction = Transaction.openOuter();
            try {
                long inserted = this.storage.itemStorage.insert((TransferVariant)ItemVariant.of((class_1799)heldStack), 1L, (TransactionContext)transaction);
                if (inserted != 1L) {
                    transaction.abort();
                    boolean bl = false;
                    return bl;
                }
                heldStack.method_7934(1);
                transaction.commit();
                boolean bl = true;
                return bl;
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        return false;
    }

    @Override
    public void sync() {
        boolean full;
        super.sync();
        boolean bl = full = !this.storage.itemStorage.isEmpty();
        if ((Boolean)this.method_11010().method_11654((class_2769)SynthesiserBlock.FULL) != full) {
            class_2680 newState = (class_2680)this.method_11010().method_11657((class_2769)SynthesiserBlock.FULL, (Comparable)Boolean.valueOf(full));
            this.field_11863.method_8501(this.field_11867, newState);
            this.method_31664(newState);
        }
    }

    protected static enum State {
        IDLE,
        RUNNING;

    }
}

