/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.neepasm.compiler;

import com.google.common.collect.Lists;
import com.neep.neepmeat.api.plc.instruction.CallInstruction;
import com.neep.neepmeat.api.plc.program.MutableProgram;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.InstructionAcceptor;
import com.neep.neepmeat.neepasm.compiler.ParsedSource;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedMacro;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.neepasm.program.Label;
import com.neep.neepmeat.plc.instruction.ReturnInstruction;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ParsedFunction
implements InstructionAcceptor {
    private final String name;
    private final Function<String, ParsedMacro> macroFinder;
    private final List<ObjectIntPair<ParsedInstruction>> instructions = Lists.newArrayList();
    private final List<Label> labels = Lists.newArrayList();

    public ParsedFunction(String name, Function<String, ParsedMacro> macroFinder) {
        this.name = name;
        this.macroFinder = macroFinder;
    }

    @Override
    public void instruction(ParsedInstruction instruction, int line) {
        this.instructions.add((ObjectIntPair<ParsedInstruction>)ObjectIntPair.of((Object)instruction, (int)line));
    }

    @Override
    public void instruction(int index, ParsedInstruction preInstruction, int line) throws NeepASM.CompilationException {
        if (index < 0 || index > this.instructions.size()) {
            throw new NeepASM.CompilationException("instruction at offset " + index + " cannot be replaced");
        }
        if (index == this.instructions.size()) {
            this.instruction(preInstruction, line);
        } else {
            this.instructions.set(index, (ObjectIntPair<ParsedInstruction>)ObjectIntPair.of((Object)preInstruction, (int)line));
        }
    }

    @Override
    public void function(ParsedFunction function) throws NeepASM.CompilationException {
        throw new NeepASM.CompilationException("cannot define function here");
    }

    @Override
    public void label(Label label) {
        this.labels.add(label);
    }

    @Override
    public int size() {
        return this.instructions.size();
    }

    @Override
    @Nullable
    public ParsedMacro findMacro(String name) {
        return this.macroFinder.apply(name);
    }

    public String mangledName() {
        return ParsedFunction.mangle(this.name);
    }

    public static String mangle(String name) {
        return name;
    }

    public Label mangleLabel(String label, int index) {
        return new Label(ParsedSource.mangleLabel(label, this.name), index);
    }

    public String name() {
        return this.name;
    }

    public void call(class_3218 world, ParsedSource parsedSource, MutableProgram program) throws NeepASM.CompilationException {
        Label label = parsedSource.findLabel(this.mangledName());
        if (label == null) {
            throw new NeepASM.CompilationException(this.name + ": label '" + this.mangledName() + "' does not exist");
        }
        program.addBack(new CallInstruction(label));
    }

    public void expand(InstructionAcceptor acceptor) {
        acceptor.label(new Label(this.mangledName(), acceptor.size()));
        for (Label label : this.labels) {
            acceptor.label(new Label(label.name(), acceptor.size() + label.index()));
        }
        int line = -1;
        for (ObjectIntPair<ParsedInstruction> pair : this.instructions) {
            acceptor.instruction((ParsedInstruction)pair.key(), pair.valueInt());
            line = pair.valueInt();
        }
        acceptor.instruction(PlcParsedInstruction.of((world, source, program) -> program.addBack(ReturnInstruction.INSTANCE)), line);
    }
}

